/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchTileEntity;
import com.simibubi.create.content.logistics.packet.ConfigureStockswitchPacket;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class StockpileSwitchScreen
extends AbstractSimiScreen {
    private ScrollInput offBelow;
    private ScrollInput onAbove;
    private IconButton confirmButton;
    private IconButton flipSignals;
    private final ITextComponent invertSignal = Lang.translate("gui.stockpile_switch.invert_signal", new Object[0]);
    private final ItemStack renderedItem = new ItemStack((IItemProvider)AllBlocks.STOCKPILE_SWITCH.get());
    private AllGuiTextures background = AllGuiTextures.STOCKSWITCH;
    private StockpileSwitchTileEntity te;
    private int lastModification;
    private LerpedFloat cursor;
    private LerpedFloat cursorLane;

    public StockpileSwitchScreen(StockpileSwitchTileEntity te) {
        super((ITextComponent)Lang.translate("gui.stockpile_switch.title", new Object[0]));
        this.te = te;
        this.lastModification = -1;
    }

    @Override
    protected void func_231160_c_() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-20, 0);
        super.func_231160_c_();
        this.widgets.clear();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.cursor = LerpedFloat.linear().startWithValue(this.te.getLevelForDisplay());
        this.cursorLane = LerpedFloat.linear().startWithValue(this.te.getState() ? 1.0 : 0.0);
        this.offBelow = new ScrollInput(x + 36, y + 40, 102, 18).withRange(0, 100).titled(StringTextComponent.field_240750_d_.func_230531_f_()).calling(state -> {
            this.lastModification = 0;
            this.offBelow.titled((IFormattableTextComponent)Lang.translate("gui.stockpile_switch.move_to_upper_at", state));
            if (this.onAbove.getState() <= state) {
                this.onAbove.setState(state + 1);
                this.onAbove.onChanged();
            }
        }).setState((int)(this.te.offWhenBelow * 100.0f));
        this.onAbove = new ScrollInput(x + 36, y + 18, 102, 18).withRange(1, 101).titled(StringTextComponent.field_240750_d_.func_230531_f_()).calling(state -> {
            this.lastModification = 0;
            this.onAbove.titled((IFormattableTextComponent)Lang.translate("gui.stockpile_switch.move_to_lower_at", state));
            if (this.offBelow.getState() >= state) {
                this.offBelow.setState(state - 1);
                this.offBelow.onChanged();
            }
        }).setState((int)(this.te.onWhenAbove * 100.0f));
        this.onAbove.onChanged();
        this.offBelow.onChanged();
        this.widgets.add(this.onAbove);
        this.widgets.add(this.offBelow);
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.widgets.add(this.confirmButton);
        this.flipSignals = new IconButton(x + 14, y + 40, AllIcons.I_FLIP);
        this.flipSignals.setToolTip(this.invertSignal);
        this.widgets.add(this.flipSignals);
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.draw(ms, (AbstractGui)this, x, y);
        AllGuiTextures.STOCKSWITCH_POWERED_LANE.draw(ms, (AbstractGui)this, x + 36, y + (this.te.isInverted() ? 18 : 40));
        AllGuiTextures.STOCKSWITCH_UNPOWERED_LANE.draw(ms, (AbstractGui)this, x + 36, y + (this.te.isInverted() ? 40 : 18));
        StockpileSwitchScreen.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(x + (this.background.width - 8) / 2), (int)(y + 3), (int)0xFFFFFF);
        AllGuiTextures sprite = AllGuiTextures.STOCKSWITCH_INTERVAL;
        float lowerBound = this.offBelow.getState();
        float upperBound = this.onAbove.getState();
        sprite.bind();
        this.func_238474_b_(ms, (int)((float)x + upperBound) + 37, y + 18, (int)((float)sprite.startX + upperBound), sprite.startY, (int)((float)sprite.width - upperBound), sprite.height);
        this.func_238474_b_(ms, x + 37, y + 40, sprite.startX, sprite.startY, (int)lowerBound, sprite.height);
        AllGuiTextures.STOCKSWITCH_ARROW_UP.draw(ms, (AbstractGui)this, (int)((float)x + lowerBound + 36.0f) - 2, y + 35);
        AllGuiTextures.STOCKSWITCH_ARROW_DOWN.draw(ms, (AbstractGui)this, (int)((float)x + upperBound + 36.0f) - 3, y + 17);
        if (this.te.currentLevel != -1.0f) {
            AllGuiTextures cursor = AllGuiTextures.STOCKSWITCH_CURSOR;
            ms.func_227860_a_();
            ms.func_227861_a_((double)Math.min(99.0f, this.cursor.getValue(partialTicks) * (float)sprite.width), (double)(this.cursorLane.getValue(partialTicks) * 22.0f), 0.0);
            cursor.draw(ms, (AbstractGui)this, x + 34, y + 19);
            ms.func_227865_b_();
        }
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.renderedItem).at(x + this.background.width + 6, y + this.background.height - 56, -200.0f)).scale(5.0).render(ms);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.cursor.chase(this.te.getLevelForDisplay(), 0.25, LerpedFloat.Chaser.EXP);
        this.cursor.tickChaser();
        this.cursorLane.chase(this.te.getState() ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        this.cursorLane.tickChaser();
        if (this.lastModification >= 0) {
            ++this.lastModification;
        }
        if (this.lastModification >= 20) {
            this.lastModification = -1;
            this.send(this.te.isInverted());
        }
    }

    public void func_231164_f_() {
        this.send(this.te.isInverted());
    }

    protected void send(boolean invert) {
        AllPackets.channel.sendToServer((Object)new ConfigureStockswitchPacket(this.te.func_174877_v(), (float)this.offBelow.getState() / 100.0f, (float)this.onAbove.getState() / 100.0f, invert));
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        if (this.flipSignals.func_230449_g_()) {
            this.send(!this.te.isInverted());
        }
        if (this.confirmButton.func_230449_g_()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return true;
        }
        return super.func_231044_a_(x, y, button);
    }
}

