/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class SandPaperPolishingRecipe
extends ProcessingRecipe<SandPaperInv> {
    public SandPaperPolishingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(AllRecipeTypes.SANDPAPER_POLISHING, params);
    }

    public boolean matches(SandPaperInv inv, World worldIn) {
        return ((Ingredient)this.ingredients.get(0)).test(inv.func_70301_a(0));
    }

    @Override
    protected int getMaxInputCount() {
        return 1;
    }

    @Override
    protected int getMaxOutputCount() {
        return 1;
    }

    public static boolean canPolish(World world, ItemStack stack) {
        return !SandPaperPolishingRecipe.getMatchingRecipes(world, stack).isEmpty();
    }

    public static ItemStack applyPolish(World world, Vector3d position, ItemStack stack, ItemStack sandPaperStack) {
        List<IRecipe<SandPaperInv>> matchingRecipes = SandPaperPolishingRecipe.getMatchingRecipes(world, stack);
        if (!matchingRecipes.isEmpty()) {
            return matchingRecipes.get(0).func_77572_b((IInventory)new SandPaperInv(stack)).func_77946_l();
        }
        return stack;
    }

    public static List<IRecipe<SandPaperInv>> getMatchingRecipes(World world, ItemStack stack) {
        return world.func_199532_z().func_215370_b(AllRecipeTypes.SANDPAPER_POLISHING.getType(), (IInventory)new SandPaperInv(stack), world);
    }

    public static class SandPaperInv
    extends RecipeWrapper {
        public SandPaperInv(ItemStack stack) {
            super((IItemHandlerModifiable)new ItemStackHandler(1));
            this.inv.setStackInSlot(0, stack);
        }
    }
}

