/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.ITriggerable;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.World;

public class BracketedTileEntityBehaviour
extends TileEntityBehaviour {
    public static BehaviourType<BracketedTileEntityBehaviour> TYPE = new BehaviourType();
    private Optional<BlockState> bracket;
    private boolean reRender;
    private Predicate<BlockState> pred;
    private Function<BlockState, ITriggerable> trigger;

    public BracketedTileEntityBehaviour(SmartTileEntity te) {
        this(te, state -> true);
    }

    public BracketedTileEntityBehaviour(SmartTileEntity te, Predicate<BlockState> pred) {
        super(te);
        this.pred = pred;
        this.bracket = Optional.empty();
    }

    public BracketedTileEntityBehaviour withTrigger(Function<BlockState, ITriggerable> trigger) {
        this.trigger = trigger;
        return this;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void applyBracket(BlockState state) {
        this.bracket = Optional.of(state);
        this.reRender = true;
        this.tileEntity.notifyUpdate();
    }

    public void triggerAdvancements(World world, PlayerEntity player, BlockState state) {
        if (this.trigger == null) {
            return;
        }
        AllTriggers.triggerFor(this.trigger.apply(state), player);
    }

    public void removeBracket(boolean inOnReplacedContext) {
        World world = this.getWorld();
        if (!world.field_72995_K) {
            world.func_217379_c(2001, this.getPos(), Block.func_196246_j((BlockState)this.getBracket()));
        }
        this.bracket = Optional.empty();
        this.reRender = true;
        if (inOnReplacedContext) {
            this.tileEntity.sendData();
        } else {
            this.tileEntity.notifyUpdate();
        }
    }

    public boolean isBracketPresent() {
        return this.getBracket() != Blocks.field_150350_a.func_176223_P();
    }

    public BlockState getBracket() {
        return this.bracket.orElse(Blocks.field_150350_a.func_176223_P());
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return ItemRequirement.of(this.getBracket(), null);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(CompoundNBT nbt, boolean clientPacket) {
        this.bracket.ifPresent(p -> nbt.func_218657_a("Bracket", (INBT)NBTUtil.func_190009_a((BlockState)p)));
        if (clientPacket && this.reRender) {
            NBTHelper.putMarker(nbt, "Redraw");
            this.reRender = false;
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundNBT nbt, boolean clientPacket) {
        this.bracket = Optional.empty();
        if (nbt.func_74764_b("Bracket")) {
            this.bracket = Optional.of(NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("Bracket")));
        }
        if (clientPacket && nbt.func_74764_b("Redraw")) {
            this.getWorld().func_184138_a(this.getPos(), this.tileEntity.func_195044_w(), this.tileEntity.func_195044_w(), 16);
        }
        super.read(nbt, clientPacket);
    }

    public boolean canHaveBracket() {
        return this.pred.test(this.tileEntity.func_195044_w());
    }
}

