/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.itemAssembly;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipeSerializer;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class SequencedAssemblyRecipe
implements IRecipe<RecipeWrapper> {
    protected ResourceLocation id;
    protected SequencedAssemblyRecipeSerializer serializer;
    protected Ingredient ingredient;
    protected List<SequencedRecipe<?>> sequence;
    protected int loops;
    protected ProcessingOutput transitionalItem;
    protected List<ProcessingOutput> resultPool;

    public SequencedAssemblyRecipe(ResourceLocation recipeId, SequencedAssemblyRecipeSerializer serializer) {
        this.id = recipeId;
        this.serializer = serializer;
        this.sequence = new ArrayList();
        this.resultPool = new ArrayList<ProcessingOutput>();
        this.loops = 5;
    }

    public static <C extends IInventory, R extends ProcessingRecipe<C>> Optional<R> getRecipe(World world, C inv, IRecipeType<R> type, Class<R> recipeClass) {
        return SequencedAssemblyRecipe.getRecipes(world, inv.func_70301_a(0), type, recipeClass).filter(r -> r.func_77569_a(inv, world)).findFirst();
    }

    public static <R extends ProcessingRecipe<?>> Optional<R> getRecipe(World world, ItemStack item, IRecipeType<R> type, Class<R> recipeClass) {
        List all = world.func_199532_z().func_241447_a_(AllRecipeTypes.SEQUENCED_ASSEMBLY.getType());
        for (SequencedAssemblyRecipe sequencedAssemblyRecipe : all) {
            SequencedRecipe<?> nextRecipe;
            ProcessingRecipe<?> recipe;
            if (!sequencedAssemblyRecipe.appliesTo(item) || (recipe = (nextRecipe = sequencedAssemblyRecipe.getNextRecipe(item)).getRecipe()).func_222127_g() != type || !recipeClass.isInstance(recipe)) continue;
            recipe.enforceNextResult(() -> sequencedAssemblyRecipe.advance(item));
            return Optional.of(recipeClass.cast(recipe));
        }
        return Optional.empty();
    }

    public static <R extends ProcessingRecipe<?>> Stream<R> getRecipes(World world, ItemStack item, IRecipeType<R> type, Class<R> recipeClass) {
        List all = world.func_199532_z().func_241447_a_(AllRecipeTypes.SEQUENCED_ASSEMBLY.getType());
        return all.stream().filter(it -> it.appliesTo(item)).map(it -> Pair.of(it, it.getNextRecipe(item).getRecipe())).filter(it -> ((ProcessingRecipe)it.getSecond()).func_222127_g() == type && recipeClass.isInstance(it.getSecond())).map(it -> {
            ((ProcessingRecipe)it.getSecond()).enforceNextResult(() -> ((SequencedAssemblyRecipe)it.getFirst()).advance(item));
            return (ProcessingRecipe)it.getSecond();
        }).map(recipeClass::cast);
    }

    private ItemStack advance(ItemStack input) {
        int step = this.getStep(input);
        if ((step + 1) / this.sequence.size() >= this.loops) {
            return this.rollResult();
        }
        ItemStack advancedItem = ItemHandlerHelper.copyStackWithSize((ItemStack)this.getTransitionalItem(), (int)1);
        CompoundNBT itemTag = advancedItem.func_196082_o();
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("id", this.id.toString());
        tag.func_74768_a("Step", step + 1);
        tag.func_74776_a("Progress", ((float)step + 1.0f) / (float)(this.sequence.size() * this.loops));
        itemTag.func_218657_a("SequencedAssembly", (INBT)tag);
        advancedItem.func_77982_d(itemTag);
        return advancedItem;
    }

    public int getLoops() {
        return this.loops;
    }

    public void addAdditionalIngredientsAndMachines(List<Ingredient> list) {
        this.sequence.forEach(sr -> sr.getAsAssemblyRecipe().addAssemblyIngredients(list));
        HashSet machines = new HashSet();
        this.sequence.forEach(sr -> sr.getAsAssemblyRecipe().addRequiredMachines(machines));
        machines.stream().map(xva$0 -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{xva$0})).forEach(list::add);
    }

    public void addAdditionalFluidIngredients(List<FluidIngredient> list) {
        this.sequence.forEach(sr -> sr.getAsAssemblyRecipe().addAssemblyFluidIngredients(list));
    }

    private ItemStack rollResult() {
        float totalWeight = 0.0f;
        for (ProcessingOutput entry : this.resultPool) {
            totalWeight += entry.getChance();
        }
        float number = Create.RANDOM.nextFloat() * totalWeight;
        for (ProcessingOutput entry : this.resultPool) {
            if (!((number -= entry.getChance()) < 0.0f)) continue;
            return entry.getStack().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private boolean appliesTo(ItemStack input) {
        if (this.ingredient.test(input)) {
            return true;
        }
        return input.func_77942_o() && this.getTransitionalItem().func_77973_b() == input.func_77973_b() && input.func_77978_p().func_74764_b("SequencedAssembly") && input.func_77978_p().func_74775_l("SequencedAssembly").func_74779_i("id").equals(this.id.toString());
    }

    private SequencedRecipe<?> getNextRecipe(ItemStack input) {
        return this.sequence.get(this.getStep(input) % this.sequence.size());
    }

    private int getStep(ItemStack input) {
        if (!input.func_77942_o()) {
            return 0;
        }
        CompoundNBT tag = input.func_77978_p();
        if (!tag.func_74764_b("SequencedAssembly")) {
            return 0;
        }
        int step = tag.func_74775_l("SequencedAssembly").func_74762_e("Step");
        return step;
    }

    public boolean matches(RecipeWrapper inv, World p_77569_2_) {
        return false;
    }

    public ItemStack assemble(RecipeWrapper p_77572_1_) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int p_194133_1_, int p_194133_2_) {
        return false;
    }

    public ItemStack func_77571_b() {
        return this.resultPool.get(0).getStack();
    }

    public float getOutputChance() {
        float totalWeight = 0.0f;
        for (ProcessingOutput entry : this.resultPool) {
            totalWeight += entry.getChance();
        }
        return this.resultPool.get(0).getChance() / totalWeight;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeType<?> func_222127_g() {
        return AllRecipeTypes.SEQUENCED_ASSEMBLY.getType();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addToTooltip(List<ITextComponent> toolTip, ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("SequencedAssembly")) {
            return;
        }
        CompoundNBT compound = stack.func_77978_p().func_74775_l("SequencedAssembly");
        ResourceLocation resourceLocation = new ResourceLocation(compound.func_74779_i("id"));
        Optional recipe = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(resourceLocation);
        if (!recipe.isPresent()) {
            return;
        }
        IRecipe iRecipe = (IRecipe)recipe.get();
        if (!(iRecipe instanceof SequencedAssemblyRecipe)) {
            return;
        }
        SequencedAssemblyRecipe sequencedAssemblyRecipe = (SequencedAssemblyRecipe)iRecipe;
        int length = sequencedAssemblyRecipe.sequence.size();
        int step = sequencedAssemblyRecipe.getStep(stack);
        int total = length * sequencedAssemblyRecipe.loops;
        toolTip.add((ITextComponent)new StringTextComponent(""));
        toolTip.add((ITextComponent)Lang.translate("recipe.sequenced_assembly", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        toolTip.add((ITextComponent)Lang.translate("recipe.assembly.progress", step, total).func_240699_a_(TextFormatting.DARK_GRAY));
        int remaining = total - step;
        for (int i = 0; i < length && i < remaining; ++i) {
            SequencedRecipe<?> sequencedRecipe = sequencedAssemblyRecipe.sequence.get((i + step) % length);
            ITextComponent textComponent = sequencedRecipe.getAsAssemblyRecipe().getDescriptionForAssembly();
            if (i == 0) {
                toolTip.add((ITextComponent)Lang.translate("recipe.assembly.next", textComponent).func_240699_a_(TextFormatting.AQUA));
                continue;
            }
            toolTip.add((ITextComponent)new StringTextComponent("-> ").func_230529_a_(textComponent).func_240699_a_(TextFormatting.DARK_AQUA));
        }
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<SequencedRecipe<?>> getSequence() {
        return this.sequence;
    }

    public ItemStack getTransitionalItem() {
        return this.transitionalItem.getStack();
    }
}

