/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.glue;

import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueItem;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class GlueEffectPacket
extends SimplePacketBase {
    private BlockPos pos;
    private Direction direction;
    private boolean fullBlock;

    public GlueEffectPacket(BlockPos pos, Direction direction, boolean fullBlock) {
        this.pos = pos;
        this.direction = direction;
        this.fullBlock = fullBlock;
    }

    public GlueEffectPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.direction = Direction.func_82600_a((int)buffer.readByte());
        this.fullBlock = buffer.readBoolean();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeByte(this.direction.func_176745_a());
        buffer.writeBoolean(this.fullBlock);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.func_71410_x();
            if (!mc.field_71439_g.func_233580_cy_().func_218141_a((Vector3i)this.pos, 100.0)) {
                return;
            }
            SuperGlueItem.spawnParticles((World)mc.field_71441_e, this.pos, this.direction, this.fullBlock);
        }));
        context.get().setPacketHandled(true);
    }
}

