/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.chassis;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.tile.TileEntityInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.StickerTileEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public class StickerInstance
extends TileEntityInstance<StickerTileEntity>
implements IDynamicInstance {
    float lastOffset = Float.NaN;
    final Direction facing;
    final boolean fakeWorld;
    final int offset;
    private final ModelData head = (ModelData)this.getTransformMaterial().getModel(AllBlockPartials.STICKER_HEAD, this.blockState).createInstance();

    public StickerInstance(MaterialManager<?> modelManager, StickerTileEntity tile) {
        super(modelManager, (TileEntity)tile);
        this.fakeWorld = tile.func_145831_w() != Minecraft.func_71410_x().field_71441_e;
        this.facing = (Direction)this.blockState.func_177229_b((Property)StickerBlock.field_176387_N);
        this.offset = (Boolean)this.blockState.func_177229_b((Property)StickerBlock.EXTENDED) != false ? 1 : 0;
        this.animateHead(this.offset);
    }

    public void beginFrame() {
        float offset = ((StickerTileEntity)this.tile).piston.getValue(AnimationTickHolder.getPartialTicks());
        if (this.fakeWorld) {
            offset = this.offset;
        }
        if (MathHelper.func_180185_a((float)offset, (float)this.lastOffset)) {
            return;
        }
        this.animateHead(offset);
        this.lastOffset = offset;
    }

    private void animateHead(float offset) {
        MatrixStack stack = new MatrixStack();
        MatrixTransformStack.of((MatrixStack)stack).translate((Vector3i)this.getInstancePosition()).nudge(((StickerTileEntity)this.tile).hashCode()).centre().rotateY((double)AngleHelper.horizontalAngle(this.facing)).rotateX((double)(AngleHelper.verticalAngle(this.facing) + 90.0f)).unCentre().translate(0.0, (double)(offset * offset * 4.0f / 16.0f), 0.0);
        this.head.setTransform(stack);
    }

    public void updateLight() {
        this.relight(this.pos, new IFlatLight[]{this.head});
    }

    public void remove() {
        this.head.delete();
    }
}

