/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.fan;

import com.simibubi.create.content.contraptions.components.fan.AirCurrent;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CKinetics;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
public interface IAirCurrentSource {
    @Nullable
    public AirCurrent getAirCurrent();

    @Nullable
    public World getAirCurrentWorld();

    public BlockPos getAirCurrentPos();

    public float getSpeed();

    public Direction getAirflowOriginSide();

    @Nullable
    public Direction getAirFlowDirection();

    default public float getMaxDistance() {
        float speed = Math.abs(this.getSpeed());
        CKinetics config = AllConfigs.SERVER.kinetics;
        float distanceFactor = Math.min(speed / (float)((Integer)config.fanRotationArgmax.get()).intValue(), 1.0f);
        float pushDistance = MathHelper.func_219799_g((float)distanceFactor, (float)3.0f, (float)((Integer)config.fanPushDistance.get()).intValue());
        float pullDistance = MathHelper.func_219799_g((float)distanceFactor, (float)3.0f, (float)((Integer)config.fanPullDistance.get()).intValue());
        return this.getSpeed() > 0.0f ? pushDistance : pullDistance;
    }

    public boolean isSourceRemoved();
}

