/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.google.common.collect.Multimap;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlockItem;
import com.simibubi.create.content.curiosities.tools.SandPaperItem;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class DeployerHandler {
    static boolean shouldActivate(ItemStack held, World world, BlockPos targetPos, @Nullable Direction facing) {
        BucketItem bucketItem;
        Fluid fluid;
        if (held.func_77973_b() instanceof BlockItem && world.func_180495_p(targetPos).func_177230_c() == ((BlockItem)held.func_77973_b()).func_179223_d()) {
            return false;
        }
        if (held.func_77973_b() instanceof BucketItem && (fluid = (bucketItem = (BucketItem)held.func_77973_b()).getFluid()) != Fluids.field_204541_a && world.func_204610_c(targetPos).func_206886_c() == fluid) {
            return false;
        }
        return held.func_190926_b() || facing != Direction.DOWN || TileEntityBehaviour.get((IBlockReader)world, targetPos, TransportedItemStackHandlerBehaviour.TYPE) == null;
    }

    static void activate(DeployerFakePlayer player, Vector3d vec, BlockPos clickedPos, Vector3d extensionVector, DeployerTileEntity.Mode mode) {
        Multimap attributeModifiers = player.func_184614_ca().func_111283_C(EquipmentSlotType.MAINHAND);
        player.func_233645_dx_().func_233793_b_(attributeModifiers);
        DeployerHandler.activateInner(player, vec, clickedPos, extensionVector, mode);
        player.func_233645_dx_().func_233793_b_(attributeModifiers);
    }

    private static void activateInner(DeployerFakePlayer player, Vector3d vec, BlockPos clickedPos, Vector3d extensionVector, DeployerTileEntity.Mode mode) {
        CompoundNBT tag;
        ActionResult onItemRightClick;
        ItemStack resultStack;
        ActionResultType onItemUse;
        boolean flag1;
        ActionResultType actionresult;
        RayTraceContext rayTraceContext;
        BlockRayTraceResult result;
        Vector3d rayOrigin = vec.func_178787_e(extensionVector.func_186678_a(1.515625));
        Vector3d rayTarget = vec.func_178787_e(extensionVector.func_186678_a(2.484375));
        player.func_70107_b(rayOrigin.field_72450_a, rayOrigin.field_72448_b, rayOrigin.field_72449_c);
        BlockPos pos = new BlockPos(vec);
        ItemStack stack = player.func_184614_ca();
        Item item = stack.func_77973_b();
        ServerWorld world = player.func_71121_q();
        List entities = world.func_217357_a(Entity.class, new AxisAlignedBB(clickedPos)).stream().filter(e -> !(e instanceof AbstractContraptionEntity)).collect(Collectors.toList());
        Hand hand = Hand.MAIN_HAND;
        if (!entities.isEmpty()) {
            Entity entity = (Entity)entities.get(world.field_73012_v.nextInt(entities.size()));
            ArrayList capturedDrops = new ArrayList();
            boolean success = false;
            entity.captureDrops(capturedDrops);
            if (mode == DeployerTileEntity.Mode.USE) {
                PlayerEntity playerEntity;
                ActionResultType cancelResult = ForgeHooks.onInteractEntity((PlayerEntity)player, (Entity)entity, (Hand)hand);
                if (cancelResult == ActionResultType.FAIL) {
                    entity.captureDrops(null);
                    return;
                }
                if (cancelResult == null) {
                    if (entity.func_184230_a((PlayerEntity)player, hand).func_226246_a_()) {
                        AbstractVillagerEntity villager;
                        if (entity instanceof AbstractVillagerEntity && (villager = (AbstractVillagerEntity)entity).func_70931_l_() instanceof DeployerFakePlayer) {
                            villager.func_70932_a_(null);
                        }
                        success = true;
                    } else if (entity instanceof LivingEntity && stack.func_111282_a_((PlayerEntity)player, (LivingEntity)entity, hand).func_226246_a_()) {
                        success = true;
                    }
                }
                if (!success && stack.func_222117_E() && entity instanceof PlayerEntity && (playerEntity = (PlayerEntity)entity).func_71043_e(item.func_219967_s().func_221468_d())) {
                    playerEntity.func_213357_a((World)world, stack);
                    player.spawnedItemEffects = stack.func_77946_l();
                    success = true;
                }
            }
            if (mode == DeployerTileEntity.Mode.PUNCH) {
                player.func_184821_cY();
                player.func_71059_n(entity);
                success = true;
            }
            entity.captureDrops(null);
            capturedDrops.forEach(e -> player.field_71071_by.func_191975_a((World)world, e.func_92059_d()));
            if (success) {
                return;
            }
        }
        if ((result = world.func_217299_a(rayTraceContext = new RayTraceContext(rayOrigin, rayTarget, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player))).func_216350_a() != clickedPos) {
            result = new BlockRayTraceResult(result.func_216347_e(), result.func_216354_b(), clickedPos, result.func_216353_d());
        }
        BlockState clickedState = world.func_180495_p(clickedPos);
        Direction face = result.func_216354_b();
        if (face == null) {
            face = Direction.func_210769_a((double)extensionVector.field_72450_a, (double)extensionVector.field_72448_b, (double)extensionVector.field_72449_c).func_176734_d();
        }
        if (mode == DeployerTileEntity.Mode.PUNCH) {
            if (!world.func_175660_a((PlayerEntity)player, clickedPos)) {
                return;
            }
            if (clickedState.func_196954_c((IBlockReader)world, clickedPos).func_197766_b()) {
                player.blockBreakingProgress = null;
                return;
            }
            PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((PlayerEntity)player, (BlockPos)clickedPos, (Direction)face);
            if (event.isCanceled()) {
                return;
            }
            if (BlockHelper.extinguishFire((World)world, (PlayerEntity)player, clickedPos, face)) {
                return;
            }
            if (event.getUseBlock() != Event.Result.DENY) {
                clickedState.func_196942_a((World)world, clickedPos, (PlayerEntity)player);
            }
            if (stack.func_190926_b()) {
                return;
            }
            float progress = clickedState.func_185903_a((PlayerEntity)player, (IBlockReader)world, clickedPos) * 16.0f;
            float before = 0.0f;
            Pair<BlockPos, Float> blockBreakingProgress = player.blockBreakingProgress;
            if (blockBreakingProgress != null) {
                before = ((Float)blockBreakingProgress.getValue()).floatValue();
            }
            progress += before;
            world.func_184133_a(null, clickedPos, clickedState.func_215695_r().func_185846_f(), SoundCategory.NEUTRAL, 0.25f, 1.0f);
            if (progress >= 1.0f) {
                DeployerHandler.tryHarvestBlock(player.field_71134_c, clickedPos);
                world.func_175715_c(player.func_145782_y(), clickedPos, -1);
                player.blockBreakingProgress = null;
                return;
            }
            if (progress <= 0.0f) {
                player.blockBreakingProgress = null;
                return;
            }
            if ((int)(before * 10.0f) != (int)(progress * 10.0f)) {
                world.func_175715_c(player.func_145782_y(), clickedPos, (int)(progress * 10.0f));
            }
            player.blockBreakingProgress = Pair.of((Object)clickedPos, (Object)Float.valueOf(progress));
            return;
        }
        ItemUseContext itemusecontext = new ItemUseContext((PlayerEntity)player, hand, result);
        Event.Result useBlock = Event.Result.DEFAULT;
        Event.Result useItem = Event.Result.DEFAULT;
        if (!clickedState.func_196954_c((IBlockReader)world, clickedPos).func_197766_b()) {
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)player, (Hand)hand, (BlockPos)clickedPos, (BlockRayTraceResult)result);
            useBlock = event.getUseBlock();
            useItem = event.getUseItem();
        }
        if (useItem != Event.Result.DENY && (actionresult = stack.onItemUseFirst(itemusecontext)) != ActionResultType.PASS) {
            return;
        }
        boolean holdingSomething = !player.func_184614_ca().func_190926_b();
        boolean bl = flag1 = !player.func_225608_bj_() || !holdingSomething || stack.doesSneakBypassUse((IWorldReader)world, clickedPos, (PlayerEntity)player);
        if (useBlock != Event.Result.DENY && flag1 && DeployerHandler.safeOnUse(clickedState, (World)world, clickedPos, (PlayerEntity)player, hand, result).func_226246_a_()) {
            return;
        }
        if (stack.func_190926_b()) {
            return;
        }
        if (useItem == Event.Result.DENY) {
            return;
        }
        if (item instanceof BlockItem && !(item instanceof CartAssemblerBlockItem) && !clickedState.func_196953_a(new BlockItemUseContext(itemusecontext))) {
            return;
        }
        if (item == Items.field_151033_d) {
            Direction newFace = result.func_216354_b();
            BlockPos newPos = result.func_216350_a();
            if (!AbstractFireBlock.func_241465_a_((World)world, (BlockPos)clickedPos, (Direction)newFace)) {
                newFace = Direction.UP;
            }
            if (clickedState.func_185904_a() == Material.field_151579_a) {
                newPos = newPos.func_177972_a(face.func_176734_d());
            }
            result = new BlockRayTraceResult(result.func_216347_e(), newFace, newPos, result.func_216353_d());
            itemusecontext = new ItemUseContext((PlayerEntity)player, hand, result);
        }
        if ((onItemUse = stack.func_196084_a(itemusecontext)).func_226246_a_()) {
            return;
        }
        if (item == Items.field_151079_bi) {
            return;
        }
        Object itemUseWorld = world;
        if (item instanceof BucketItem || item instanceof SandPaperItem) {
            itemUseWorld = new ItemUseWorld((World)world, face, pos);
        }
        if ((resultStack = (ItemStack)(onItemRightClick = item.func_77659_a((World)itemUseWorld, (PlayerEntity)player, hand)).func_188398_b()) != stack || resultStack.func_190916_E() != stack.func_190916_E() || resultStack.func_77988_m() > 0 || resultStack.func_77952_i() != stack.func_77952_i()) {
            player.func_184611_a(hand, (ItemStack)onItemRightClick.func_188398_b());
        }
        if ((tag = stack.func_77978_p()) != null && stack.func_77973_b() instanceof SandPaperItem && tag.func_74764_b("Polishing")) {
            player.spawnedItemEffects = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Polishing"));
            AllSoundEvents.AUTO_POLISH.playOnServer((World)world, pos, 0.25f, 1.0f);
        }
        if (!player.func_184607_cu().func_190926_b()) {
            player.func_184611_a(hand, stack.func_77950_b((World)world, (LivingEntity)player));
        }
        player.func_184602_cy();
    }

    public static boolean tryHarvestBlock(PlayerInteractionManager interactionManager, BlockPos pos) {
        ServerWorld world = interactionManager.field_73092_a;
        ServerPlayerEntity player = interactionManager.field_73090_b;
        BlockState blockstate = world.func_180495_p(pos);
        GameType gameType = interactionManager.func_73081_b();
        if (ForgeHooks.onBlockBreakEvent((World)world, (GameType)gameType, (ServerPlayerEntity)player, (BlockPos)pos) == -1) {
            return false;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (player.func_184614_ca().onBlockStartBreak(pos, (PlayerEntity)player)) {
            return false;
        }
        if (player.func_223729_a((World)world, pos, gameType)) {
            return false;
        }
        ItemStack prevHeldItem = player.func_184614_ca();
        ItemStack heldItem = prevHeldItem.func_77946_l();
        boolean canHarvest = blockstate.canHarvestBlock((IBlockReader)world, pos, (PlayerEntity)player);
        prevHeldItem.func_179548_a((World)world, blockstate, pos, (PlayerEntity)player);
        if (prevHeldItem.func_190926_b() && !heldItem.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)heldItem, (Hand)Hand.MAIN_HAND);
        }
        BlockPos posUp = pos.func_177984_a();
        BlockState stateUp = world.func_180495_p(posUp);
        if (blockstate.func_177230_c() instanceof DoublePlantBlock && blockstate.func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.LOWER && stateUp.func_177230_c() == blockstate.func_177230_c() && stateUp.func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_180501_a(posUp, Blocks.field_150350_a.func_176223_P(), 35);
        } else if (!blockstate.removedByPlayer((World)world, pos, (PlayerEntity)player, canHarvest, world.func_204610_c(pos))) {
            return true;
        }
        blockstate.func_177230_c().func_176206_d((IWorld)world, pos, blockstate);
        if (!canHarvest) {
            return true;
        }
        Block.func_220077_a((BlockState)blockstate, (ServerWorld)world, (BlockPos)pos, (TileEntity)tileentity, (Entity)player, (ItemStack)prevHeldItem).forEach(item -> player.field_71071_by.func_191975_a((World)world, item));
        blockstate.func_215706_a(world, pos, prevHeldItem);
        return true;
    }

    public static ActionResultType safeOnUse(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (state.func_177230_c() instanceof BeehiveBlock) {
            return DeployerHandler.safeOnBeehiveUse(state, world, pos, player, hand);
        }
        return state.func_227031_a_(world, player, hand, ray);
    }

    protected static ActionResultType safeOnBeehiveUse(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand) {
        BeehiveBlock block = (BeehiveBlock)state.func_177230_c();
        ItemStack prevHeldItem = player.func_184586_b(hand);
        int honeyLevel = (Integer)state.func_177229_b((Property)BeehiveBlock.field_226873_c_);
        boolean success = false;
        if (honeyLevel < 5) {
            return ActionResultType.PASS;
        }
        if (prevHeldItem.func_77973_b() == Items.field_151097_aZ) {
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            player.field_71071_by.func_191975_a(world, new ItemStack((IItemProvider)Items.field_226635_pU_, 3));
            prevHeldItem.func_222118_a(1, (LivingEntity)player, s -> s.func_213334_d(hand));
            success = true;
        }
        if (prevHeldItem.func_77973_b() == Items.field_151069_bo) {
            prevHeldItem.func_190918_g(1);
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            ItemStack honeyBottle = new ItemStack((IItemProvider)Items.field_226638_pX_);
            if (prevHeldItem.func_190926_b()) {
                player.func_184611_a(hand, honeyBottle);
            } else {
                player.field_71071_by.func_191975_a(world, honeyBottle);
            }
            success = true;
        }
        if (!success) {
            return ActionResultType.PASS;
        }
        block.func_226876_a_(world, state, pos);
        return ActionResultType.SUCCESS;
    }

    private static final class ItemUseWorld
    extends WrappedWorld {
        private final Direction face;
        private final BlockPos pos;
        boolean rayMode = false;

        private ItemUseWorld(World world, Direction face, BlockPos pos) {
            super(world, world.func_72863_F());
            this.face = face;
            this.pos = pos;
        }

        public BlockRayTraceResult func_217299_a(RayTraceContext context) {
            this.rayMode = true;
            BlockRayTraceResult rayTraceBlocks = super.func_217299_a(context);
            this.rayMode = false;
            return rayTraceBlocks;
        }

        @Override
        public BlockState func_180495_p(BlockPos position) {
            if (this.rayMode && (this.pos.func_177967_a(this.face.func_176734_d(), 3).equals((Object)position) || this.pos.func_177967_a(this.face.func_176734_d(), 1).equals((Object)position))) {
                return Blocks.field_150357_h.func_176223_P();
            }
            return this.world.func_180495_p(position);
        }
    }
}

