/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.components.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.processing.InWorldProcessing;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.curiosities.tools.SandPaperPolishingRecipe;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class BeltDeployerCallbacks {
    public static BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerTileEntity deployerTileEntity) {
        ItemStack held;
        if (deployerTileEntity.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (deployerTileEntity.mode == DeployerTileEntity.Mode.PUNCH) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        BlockState blockState = deployerTileEntity.func_195044_w();
        if (!blockState.func_235901_b_((Property)DirectionalKineticBlock.FACING) || blockState.func_177229_b((Property)DirectionalKineticBlock.FACING) != Direction.DOWN) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (deployerTileEntity.state != DeployerTileEntity.State.WAITING) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (deployerTileEntity.redstoneLocked) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        DeployerFakePlayer player = deployerTileEntity.getPlayer();
        ItemStack itemStack = held = player == null ? ItemStack.field_190927_a : player.func_184614_ca();
        if (held.func_190926_b()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (deployerTileEntity.getRecipe(s.stack) == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        deployerTileEntity.start();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public static BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerTileEntity deployerTileEntity) {
        ItemStack held;
        if (deployerTileEntity.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        BlockState blockState = deployerTileEntity.func_195044_w();
        if (!blockState.func_235901_b_((Property)DirectionalKineticBlock.FACING) || blockState.func_177229_b((Property)DirectionalKineticBlock.FACING) != Direction.DOWN) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        DeployerFakePlayer player = deployerTileEntity.getPlayer();
        ItemStack itemStack = held = player == null ? ItemStack.field_190927_a : player.func_184614_ca();
        if (held.func_190926_b()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        IRecipe<? extends IInventory> recipe = deployerTileEntity.getRecipe(s.stack);
        if (recipe == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (deployerTileEntity.state == DeployerTileEntity.State.RETRACTING && deployerTileEntity.timer == 1000) {
            BeltDeployerCallbacks.activate(s, i, deployerTileEntity, recipe);
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (deployerTileEntity.state == DeployerTileEntity.State.WAITING) {
            if (deployerTileEntity.redstoneLocked) {
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            deployerTileEntity.start();
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public static void activate(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, DeployerTileEntity deployerTileEntity, IRecipe<?> recipe) {
        boolean keepHeld;
        List<TransportedItemStack> collect = InWorldProcessing.applyRecipeOn(ItemHandlerHelper.copyStackWithSize((ItemStack)transported.stack, (int)1), recipe).stream().map(stack -> {
            TransportedItemStack copy = transported.copy();
            boolean centered = BeltHelper.isItemUpright(stack);
            copy.stack = stack;
            copy.locked = true;
            copy.angle = centered ? 180 : Create.RANDOM.nextInt(360);
            return copy;
        }).map(t -> {
            t.locked = false;
            return t;
        }).collect(Collectors.toList());
        TransportedItemStack left = transported.copy();
        deployerTileEntity.player.spawnedItemEffects = transported.stack.func_77946_l();
        left.stack.func_190918_g(1);
        if (collect.isEmpty()) {
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(left));
        } else {
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(collect, left));
        }
        ItemStack heldItem = deployerTileEntity.player.func_184614_ca();
        boolean unbreakable = heldItem.func_77942_o() && heldItem.func_77978_p().func_74767_n("Unbreakable");
        boolean bl = keepHeld = recipe instanceof DeployerApplicationRecipe && ((DeployerApplicationRecipe)recipe).shouldKeepHeldItem();
        if (!unbreakable && !keepHeld) {
            if (heldItem.func_77984_f()) {
                heldItem.func_222118_a(1, (LivingEntity)deployerTileEntity.player, s -> s.func_213334_d(Hand.MAIN_HAND));
            } else {
                heldItem.func_190918_g(1);
            }
        }
        BlockPos pos = deployerTileEntity.func_174877_v();
        World world = deployerTileEntity.func_145831_w();
        if (heldItem.func_190926_b()) {
            world.func_184133_a(null, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.25f, 1.0f);
        }
        world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.25f, 0.75f);
        if (recipe instanceof SandPaperPolishingRecipe) {
            AllSoundEvents.AUTO_POLISH.playOnServer(world, pos, 0.25f, 1.0f);
        }
        deployerTileEntity.sendData();
    }
}

