/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;

public class EdChair {
    private static boolean sitting_enabled = true;
    private static double sitting_probability = 0.1;
    private static double standup_probability = 0.01;

    public static void on_config(boolean without_sitting, boolean without_mob_sitting, double sitting_probability_percent, double standup_probability_percent) {
        sitting_enabled = !without_sitting;
        sitting_probability = without_sitting || without_mob_sitting ? 0.0 : MathHelper.func_151237_a((double)(sitting_probability_percent / 100.0), (double)0.0, (double)0.9);
        standup_probability = without_sitting || without_mob_sitting ? 1.0 : MathHelper.func_151237_a((double)(standup_probability_percent / 100.0), (double)1.0E-6, (double)0.01);
        ModConfig.log("Config chairs: sit:" + sitting_enabled + ", mob-sit: " + sitting_probability * 100.0 + "%, standup: " + standup_probability + "%.");
    }

    public static class EntityChair
    extends Entity {
        public static final double x_offset = 0.5;
        public static final double y_offset = 0.4;
        public static final double z_offset = 0.5;
        private int t_sit = 0;
        public BlockPos chair_pos = new BlockPos(0, 0, 0);

        public EntityChair(EntityType<? extends Entity> entityType, World world) {
            super(entityType, world);
            this.field_70156_m = true;
            this.func_213317_d(Vector3d.field_186680_a);
            this.canUpdate(true);
            this.field_70145_X = true;
        }

        public EntityChair(World world) {
            this(ModContent.ET_CHAIR, world);
        }

        public static EntityChair customClientFactory(FMLPlayMessages.SpawnEntity spkt, World world) {
            return new EntityChair(world);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        public static boolean accepts_mob(LivingEntity entity) {
            if (!(entity instanceof MonsterEntity)) {
                return false;
            }
            if ((double)entity.func_200600_R().func_220334_j().field_220316_b > 2.5 || (double)entity.func_200600_R().func_220334_j().field_220316_b > 2.0) {
                return false;
            }
            if (entity instanceof ZombieEntity) {
                return true;
            }
            if (entity instanceof ZombieVillagerEntity) {
                return true;
            }
            if (entity instanceof ZombifiedPiglinEntity) {
                return true;
            }
            if (entity instanceof PiglinEntity) {
                return true;
            }
            if (entity instanceof HuskEntity) {
                return true;
            }
            if (entity instanceof StrayEntity) {
                return true;
            }
            if (entity instanceof SkeletonEntity) {
                return true;
            }
            return entity instanceof WitherSkeletonEntity;
        }

        public static void sit(World world, LivingEntity sitter, BlockPos pos) {
            if (!sitting_enabled) {
                return;
            }
            if (world == null || world.field_72995_K || sitter == null || pos == null) {
                return;
            }
            if (!(sitter instanceof PlayerEntity) && !EntityChair.accepts_mob(sitter)) {
                return;
            }
            if (!world.func_217357_a(EntityChair.class, new AxisAlignedBB(pos)).isEmpty()) {
                return;
            }
            if (sitter.func_184207_aI() || !sitter.func_70089_S() || sitter.func_184218_aH()) {
                return;
            }
            if (!world.func_175623_d(pos.func_177984_a()) || !world.func_175623_d(pos.func_177981_b(2))) {
                return;
            }
            boolean on_top_of_block_position = true;
            boolean use_next_negative_y_position = false;
            EntityChair chair = new EntityChair(world);
            BlockPos chair_pos = chair.func_233580_cy_();
            chair.chair_pos = pos;
            chair.t_sit = 5;
            chair.field_70169_q = chair_pos.func_177958_n();
            chair.field_70167_r = chair_pos.func_177956_o();
            chair.field_70166_s = chair_pos.func_177952_p();
            chair.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.5);
            world.func_217376_c((Entity)chair);
            sitter.func_184205_a((Entity)chair, true);
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(CompoundNBT compound) {
        }

        protected void func_213281_b(CompoundNBT compound) {
        }

        public boolean func_70104_M() {
            return false;
        }

        public double func_70042_X() {
            return 0.0;
        }

        public void func_70071_h_() {
            Entity sitter;
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            super.func_70071_h_();
            if (--this.t_sit > 0) {
                return;
            }
            Entity entity = sitter = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
            if (sitter == null || !sitter.func_70089_S()) {
                this.func_70106_y();
                return;
            }
            boolean abort = !sitting_enabled;
            BlockState state = this.field_70170_p.func_180495_p(this.chair_pos);
            if (state == null || !(state.func_177230_c() instanceof ChairBlock)) {
                abort = true;
            }
            if (!this.field_70170_p.func_175623_d(this.chair_pos.func_177984_a())) {
                abort = true;
            }
            if (!(sitter instanceof PlayerEntity) && Math.random() < standup_probability) {
                abort = true;
            }
            if (abort) {
                for (Entity e : this.func_184188_bt()) {
                    if (!e.func_70089_S()) continue;
                    e.func_184210_p();
                }
                this.func_70106_y();
            }
        }
    }

    public static class ChairBlock
    extends DecorBlock.HorizontalWaterLoggable
    implements IDecorBlock {
        public ChairBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB[] unrotatedAABBs) {
            super(config, builder.func_200944_c(), unrotatedAABBs);
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (!sitting_enabled) {
                return ActionResultType.PASS;
            }
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            EntityChair.sit(world, (LivingEntity)player, pos);
            return ActionResultType.CONSUME;
        }

        public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
            if (sitting_enabled && Math.random() < sitting_probability && entity instanceof MobEntity) {
                EntityChair.sit(world, (LivingEntity)entity, pos);
            }
        }

        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rnd) {
            if (!sitting_enabled || sitting_probability < 1.0E-6) {
                return;
            }
            List entities = world.func_175647_a(MobEntity.class, new AxisAlignedBB(pos).func_72314_b(2.0, 1.0, 2.0).func_72321_a(0.0, 1.0, 0.0), e -> true);
            if (entities.isEmpty()) {
                return;
            }
            int index = rnd.nextInt(entities.size());
            if (index < 0 || index >= entities.size()) {
                return;
            }
            EntityChair.sit((World)world, (LivingEntity)entities.get(index), pos);
        }
    }
}

