/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.backend.gl.attrib.VertexFormat;
import com.jozufozu.flywheel.backend.gl.buffer.VecBuffer;
import com.jozufozu.flywheel.core.Formats;
import com.jozufozu.flywheel.core.model.IModel;
import com.jozufozu.flywheel.core.model.ModelUtil;
import com.jozufozu.flywheel.util.BufferBuilderReader;
import java.util.Collection;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.gen.feature.template.Template;

public class WorldModel
implements IModel {
    private final BufferBuilderReader reader;

    public WorldModel(IBlockDisplayReader renderWorld, RenderType layer, Collection<Template.BlockInfo> blocks) {
        this.reader = new BufferBuilderReader(ModelUtil.getBufferBuilderFromTemplate(renderWorld, layer, blocks));
    }

    @Override
    public void buffer(VecBuffer vertices) {
        for (int i = 0; i < this.vertexCount(); ++i) {
            vertices.putVec3(this.reader.getX(i), this.reader.getY(i), this.reader.getZ(i));
            vertices.putVec3(this.reader.getNX(i), this.reader.getNY(i), this.reader.getNZ(i));
            vertices.putVec2(this.reader.getU(i), this.reader.getV(i));
            vertices.putColor(this.reader.getR(i), this.reader.getG(i), this.reader.getB(i), this.reader.getA(i));
            int light = this.reader.getLight(i);
            byte block = (byte)(LightTexture.func_228450_a_((int)light) << 4);
            byte sky = (byte)(LightTexture.func_228454_b_((int)light) << 4);
            vertices.putVec2(block, sky);
        }
    }

    @Override
    public int vertexCount() {
        return this.reader.getVertexCount();
    }

    @Override
    public VertexFormat format() {
        return Formats.COLORED_LIT_MODEL;
    }
}

