/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.state;

import com.jozufozu.flywheel.backend.gl.GlTextureUnit;
import com.jozufozu.flywheel.backend.state.IRenderState;
import com.jozufozu.flywheel.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class TextureRenderState
implements IRenderState {
    private static final Map<Pair<GlTextureUnit, ResourceLocation>, TextureRenderState> states = new HashMap<Pair<GlTextureUnit, ResourceLocation>, TextureRenderState>();
    public final GlTextureUnit unit;
    public final ResourceLocation location;

    private TextureRenderState(GlTextureUnit unit, ResourceLocation location) {
        this.unit = unit;
        this.location = location;
    }

    public static TextureRenderState get(ResourceLocation texture) {
        return TextureRenderState.get(GlTextureUnit.T0, texture);
    }

    public static TextureRenderState get(GlTextureUnit unit, ResourceLocation texture) {
        return states.computeIfAbsent(Pair.of(unit, texture), p -> new TextureRenderState((GlTextureUnit)((Object)((Object)p.getFirst())), (ResourceLocation)p.getSecond()));
    }

    @Override
    public void bind() {
        this.unit.makeActive();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.location);
    }

    @Override
    public void unbind() {
    }

    @Override
    @Nullable
    public ResourceLocation getTexture(GlTextureUnit textureUnit) {
        if (textureUnit == this.unit) {
            return this.location;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextureRenderState that = (TextureRenderState)o;
        return this.location.equals((Object)that.location);
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }
}

