/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.model;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlPrimitive;
import com.jozufozu.flywheel.backend.model.BufferedModel;
import com.jozufozu.flywheel.backend.model.ElementBuffer;
import com.jozufozu.flywheel.core.model.IModel;
import org.lwjgl.opengl.GL20;

public class IndexedModel
extends BufferedModel {
    protected ElementBuffer ebo;

    public IndexedModel(IModel model) {
        super(GlPrimitive.TRIANGLES, model);
        this.ebo = model.createEBO();
    }

    @Override
    public void setupState() {
        super.setupState();
        this.ebo.bind();
    }

    @Override
    public void clearState() {
        super.clearState();
        this.ebo.unbind();
    }

    @Override
    public void drawCall() {
        GL20.glDrawElements((int)this.primitiveMode.glEnum, (int)this.ebo.elementCount, (int)this.ebo.eboIndexType.getGlEnum(), (long)0L);
    }

    @Override
    public void drawInstances(int instanceCount) {
        if (!this.valid()) {
            return;
        }
        Backend.getInstance().compat.drawInstanced.drawElementsInstanced(this.primitiveMode, this.ebo.elementCount, this.ebo.eboIndexType, 0L, instanceCount);
    }
}

