/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.loading;

import com.jozufozu.flywheel.backend.loading.Program;
import com.jozufozu.flywheel.backend.loading.TaggedField;
import com.jozufozu.flywheel.backend.loading.TypeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaggedStruct {
    static final Pattern taggedStruct = Pattern.compile("#\\[(\\w*)]\\s*struct\\s+([\\w\\d]*)\\s*\\{([\\w\\d \\t#\\[\\](),;\\n]*)}\\s*;");
    int srcStart;
    int srcEnd;
    String source;
    String tag;
    String name;
    String body;
    List<TaggedField> fields = new ArrayList<TaggedField>(4);
    Map<String, String> fields2Types = new HashMap<String, String>();

    public TaggedStruct(Matcher foundMatcher) {
        this.source = foundMatcher.group();
        this.srcStart = foundMatcher.start();
        this.srcEnd = foundMatcher.end();
        this.tag = foundMatcher.group(1);
        this.name = foundMatcher.group(2);
        this.body = foundMatcher.group(3);
        Matcher fielder = TaggedField.fieldPattern.matcher(this.body);
        while (fielder.find()) {
            this.fields.add(new TaggedField(fielder));
            this.fields2Types.put(fielder.group(2), fielder.group(1));
        }
    }

    public void addPrefixedAttributes(Program builder, String prefix) {
        for (TaggedField field : this.fields) {
            int attributeCount = TypeHelper.getAttributeCount(field.type);
            builder.addAttribute(prefix + field.name, attributeCount);
        }
    }
}

