/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.tile;

import com.jozufozu.flywheel.backend.instancing.IInstance;
import com.jozufozu.flywheel.backend.material.InstanceMaterial;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.jozufozu.flywheel.core.materials.OrientedData;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public abstract class TileEntityInstance<T extends TileEntity>
implements IInstance {
    protected final MaterialManager<?> materialManager;
    protected final T tile;
    protected final World world;
    protected final BlockPos pos;
    protected final BlockPos instancePos;
    protected final BlockState blockState;

    public TileEntityInstance(MaterialManager<?> materialManager, T tile) {
        this.materialManager = materialManager;
        this.tile = tile;
        this.world = tile.func_145831_w();
        this.pos = tile.func_174877_v();
        this.blockState = tile.func_195044_w();
        this.instancePos = this.pos.func_177973_b(materialManager.getOriginCoordinate());
    }

    @Override
    public void update() {
    }

    @Override
    public void updateLight() {
    }

    @Override
    public abstract void remove();

    @Override
    public boolean shouldReset() {
        return this.tile.func_195044_w() != this.blockState;
    }

    public BlockPos getInstancePosition() {
        return this.pos.func_177973_b(this.materialManager.getOriginCoordinate());
    }

    @Override
    public BlockPos getWorldPosition() {
        return this.pos;
    }

    protected void relight(BlockPos pos, IFlatLight<?> ... models) {
        this.relight(this.world.func_226658_a_(LightType.BLOCK, pos), this.world.func_226658_a_(LightType.SKY, pos), models);
    }

    protected <L extends IFlatLight<?>> void relight(BlockPos pos, Stream<L> models) {
        this.relight(this.world.func_226658_a_(LightType.BLOCK, pos), this.world.func_226658_a_(LightType.SKY, pos), models);
    }

    protected void relight(int block, int sky, IFlatLight<?> ... models) {
        this.relight(block, sky, Arrays.stream(models));
    }

    protected <L extends IFlatLight<?>> void relight(int block, int sky, Stream<L> models) {
        models.forEach(model -> ((IFlatLight)model.setBlockLight(block)).setSkyLight(sky));
    }

    protected InstanceMaterial<ModelData> getTransformMaterial() {
        return this.materialManager.defaultCutout().material(Materials.TRANSFORMED);
    }

    protected InstanceMaterial<OrientedData> getOrientedMaterial() {
        return this.materialManager.defaultCutout().material(Materials.ORIENTED);
    }
}

