/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.buffer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class VecBuffer {
    protected ByteBuffer internal;

    public VecBuffer() {
    }

    public VecBuffer(ByteBuffer internal) {
        this.internal = internal;
    }

    public static VecBuffer allocate(int bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        buffer.order(ByteOrder.nativeOrder());
        return new VecBuffer(buffer);
    }

    protected void setInternal(ByteBuffer internal) {
        this.internal = internal;
    }

    public ByteBuffer unwrap() {
        return this.internal;
    }

    public VecBuffer rewind() {
        ((Buffer)this.internal).rewind();
        return this;
    }

    public VecBuffer putFloatArray(float[] floats) {
        this.internal.asFloatBuffer().put(floats);
        this.internal.position(this.internal.position() + floats.length * 4);
        return this;
    }

    public VecBuffer putByteArray(byte[] bytes) {
        this.internal.put(bytes);
        return this;
    }

    public VecBuffer position(int p) {
        this.internal.position(p);
        return this;
    }

    public VecBuffer putFloat(float f) {
        this.internal.putFloat(f);
        return this;
    }

    public VecBuffer putInt(int i) {
        this.internal.putInt(i);
        return this;
    }

    public VecBuffer put(byte b) {
        this.internal.put(b);
        return this;
    }

    public VecBuffer put(ByteBuffer b) {
        this.internal.put(b);
        return this;
    }

    public VecBuffer putVec4(float x, float y, float z, float w) {
        this.internal.putFloat(x);
        this.internal.putFloat(y);
        this.internal.putFloat(z);
        this.internal.putFloat(w);
        return this;
    }

    public VecBuffer putColor(int r, int g, int b, int a) {
        this.internal.put((byte)r);
        this.internal.put((byte)g);
        this.internal.put((byte)b);
        this.internal.put((byte)a);
        return this;
    }

    public VecBuffer putColor(byte r, byte g, byte b, byte a) {
        this.internal.put(r);
        this.internal.put(g);
        this.internal.put(b);
        this.internal.put(a);
        return this;
    }

    public VecBuffer putVec3(float x, float y, float z) {
        this.internal.putFloat(x);
        this.internal.putFloat(y);
        this.internal.putFloat(z);
        return this;
    }

    public VecBuffer putVec2(float x, float y) {
        this.internal.putFloat(x);
        this.internal.putFloat(y);
        return this;
    }

    public VecBuffer putVec3(byte x, byte y, byte z) {
        this.internal.put(x);
        this.internal.put(y);
        this.internal.put(z);
        return this;
    }

    public VecBuffer putVec2(byte x, byte y) {
        this.internal.put(x);
        this.internal.put(y);
        return this;
    }
}

