/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.IShaderContext;
import com.jozufozu.flywheel.backend.ResourceUtil;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.backend.loading.Shader;
import com.jozufozu.flywheel.backend.loading.ShaderLoadingException;
import com.jozufozu.flywheel.core.crumbling.CrumblingRenderer;
import com.jozufozu.flywheel.core.shader.spec.ProgramSpec;
import com.jozufozu.flywheel.event.GatherContextEvent;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.lwjgl.system.MemoryUtil;

public class ShaderSources
implements ISelectiveResourceReloadListener {
    public static final String SHADER_DIR = "flywheel/shaders/";
    public static final String PROGRAM_DIR = "flywheel/programs/";
    public static final ArrayList<String> EXTENSIONS = Lists.newArrayList((Object[])new String[]{".vert", ".vsh", ".frag", ".fsh", ".glsl"});
    private static final Gson GSON = new GsonBuilder().create();
    private final Map<ResourceLocation, String> shaderSource = new HashMap<ResourceLocation, String>();
    private boolean shouldCrash;
    private final Backend backend;

    public ShaderSources(Backend backend) {
        this.backend = backend;
        IResourceManager manager = backend.minecraft.func_195551_G();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_219534_a((IFutureReloadListener)this);
        }
    }

    public void onResourceManagerReload(IResourceManager manager, Predicate<IResourceType> predicate) {
        if (predicate.test((IResourceType)VanillaResourceType.SHADERS)) {
            this.backend.refresh();
            if (this.backend.gl20()) {
                this.shaderSource.clear();
                this.shouldCrash = false;
                this.backend.clearContexts();
                ModLoader.get().postEvent((Event)new GatherContextEvent(this.backend));
                this.loadProgramSpecs(manager);
                this.loadShaderSources(manager);
                for (IShaderContext<?> context : this.backend.allContexts()) {
                    context.load();
                }
                if (this.shouldCrash) {
                    throw new ShaderLoadingException("Could not load all shaders, see log for details");
                }
                Backend.log.info("Loaded all shader programs.");
                this.shaderSource.clear();
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (Backend.isFlywheelWorld((IWorld)world)) {
                    InstancedRenderDispatcher.loadAllInWorld(world);
                    CrumblingRenderer.reset();
                }
            }
        }
    }

    private void loadProgramSpecs(IResourceManager manager) {
        Collection programSpecs = manager.func_199003_a(PROGRAM_DIR, s -> s.endsWith(".json"));
        for (ResourceLocation location : programSpecs) {
            try {
                IResource file = manager.func_199002_a(location);
                String s2 = this.readToString(file.func_199027_b());
                ResourceLocation specName = ResourceUtil.trim(location, PROGRAM_DIR, ".json");
                DataResult result = ProgramSpec.CODEC.decode((DynamicOps)JsonOps.INSTANCE, GSON.fromJson(s2, JsonElement.class));
                ProgramSpec spec = (ProgramSpec)((Pair)result.get().orThrow()).getFirst();
                spec.setName(specName);
                this.backend.register(spec);
            }
            catch (Exception e) {
                Backend.log.error((Object)e);
            }
        }
    }

    public void notifyError() {
        this.shouldCrash = true;
    }

    @Nonnull
    public String getShaderSource(ResourceLocation loc) {
        String source = this.shaderSource.get(loc);
        if (source == null) {
            throw new ShaderLoadingException(String.format("shader '%s' does not exist", loc));
        }
        return source;
    }

    private void loadShaderSources(IResourceManager manager) {
        Collection allShaders = manager.func_199003_a(SHADER_DIR, s -> {
            for (String ext : EXTENSIONS) {
                if (!s.endsWith(ext)) continue;
                return true;
            }
            return false;
        });
        for (ResourceLocation location : allShaders) {
            try {
                IResource resource = manager.func_199002_a(location);
                String file = this.readToString(resource.func_199027_b());
                ResourceLocation name = ResourceUtil.removePrefixUnchecked(location, SHADER_DIR);
                this.shaderSource.put(name, file);
            }
            catch (IOException iOException) {}
        }
    }

    public Shader source(ResourceLocation name, ShaderType type) {
        return new Shader(this, type, name, this.getShaderSource(name));
    }

    public static Stream<String> lines(String s) {
        return new BufferedReader(new StringReader(s)).lines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readToString(InputStream is) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = this.readToBuffer(is);
            int i = bytebuffer.position();
            ((Buffer)bytebuffer).rewind();
            String string = MemoryUtil.memASCII((ByteBuffer)bytebuffer, (int)i);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return null;
    }

    public ByteBuffer readToBuffer(InputStream is) throws IOException {
        ByteBuffer bytebuffer;
        if (is instanceof FileInputStream) {
            FileInputStream fileinputstream = (FileInputStream)is;
            FileChannel filechannel = fileinputstream.getChannel();
            bytebuffer = MemoryUtil.memAlloc((int)((int)filechannel.size() + 1));
            while (filechannel.read(bytebuffer) != -1) {
            }
        } else {
            bytebuffer = MemoryUtil.memAlloc((int)8192);
            ReadableByteChannel readablebytechannel = Channels.newChannel(is);
            while (readablebytechannel.read(bytebuffer) != -1) {
                if (bytebuffer.remaining() != 0) continue;
                bytebuffer = MemoryUtil.memRealloc((ByteBuffer)bytebuffer, (int)(bytebuffer.capacity() * 2));
            }
        }
        return bytebuffer;
    }
}

