/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.wiki;

import me.ferdz.placeableitems.block.PlaceableItemsBlock;
import me.ferdz.placeableitems.block.component.IBlockComponent;
import me.ferdz.placeableitems.wiki.WikiBlockComponentDefinition;
import me.ferdz.placeableitems.wiki.WikiDefinition;
import org.apache.commons.lang3.StringUtils;

public class WikiItem {
    public final String itemName;
    public final String description;
    public final String modelPath;
    public final Texture[] textures;

    public WikiItem(PlaceableItemsBlock block, WikiDefinition wiki) {
        this.itemName = wiki.name().isEmpty() ? block.func_199767_j().func_200296_o().getString() : StringUtils.stripToNull((String)wiki.name());
        String description = wiki.description();
        StringBuilder componentsDescription = new StringBuilder();
        for (IBlockComponent component : block.getComponents()) {
            WikiBlockComponentDefinition annotation = component.getClass().getAnnotation(WikiBlockComponentDefinition.class);
            if (annotation == null) continue;
            componentsDescription.append(annotation.description()).append("\n");
        }
        if (componentsDescription.length() > 0) {
            description = description + "\n" + componentsDescription.toString();
        }
        this.description = StringUtils.stripToNull((String)description);
        this.modelPath = wiki.model().isEmpty() ? "models/block/" + block.func_199767_j().getRegistryName().func_110623_a() + ".json" : "models/block/" + wiki.model() + ".json";
        if (wiki.textures().length > 0) {
            this.textures = new Texture[wiki.textures().length];
            WikiDefinition.Texture[] wikiTextures = wiki.textures();
            for (int i = 0; i < wikiTextures.length; ++i) {
                WikiDefinition.Texture wikiTexture = wikiTextures[i];
                this.textures[i] = new Texture(wikiTexture.name(), "textures/block/" + wikiTexture.texture() + ".png");
            }
        } else {
            this.textures = new Texture[]{new Texture(block.func_199767_j().getRegistryName().func_110623_a(), "textures/block/" + block.func_199767_j().getRegistryName().func_110623_a() + ".png")};
        }
    }

    public class Texture {
        public final String name;
        public final String texture;

        public Texture(String name, String texture) {
            this.name = name;
            this.texture = texture;
        }
    }
}

