/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.wiki;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.ferdz.placeableitems.block.PlaceableItemsBlock;
import me.ferdz.placeableitems.init.PlaceableItemsBlockRegistry;
import me.ferdz.placeableitems.wiki.WikiDefinition;
import me.ferdz.placeableitems.wiki.WikiItem;

public class WikiGenerator {
    private static final String WIKI_PATH = "../../wiki/";
    private static final String WIKI_FILE_NAME = "data.json";
    private Class<PlaceableItemsBlockRegistry> registryClass = PlaceableItemsBlockRegistry.class;

    public void generate() {
        try {
            ArrayList<WikiItem> items = new ArrayList<WikiItem>();
            List fields = Stream.of(this.registryClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(WikiDefinition.class)).collect(Collectors.toList());
            for (Field field : fields) {
                field.setAccessible(true);
                WikiDefinition wikiAnnotation = field.getAnnotation(WikiDefinition.class);
                PlaceableItemsBlock block = (PlaceableItemsBlock)((Object)field.get(null));
                items.add(new WikiItem(block, wikiAnnotation));
            }
            new File(WIKI_PATH).mkdirs();
            Gson gson = new Gson();
            Files.write(Paths.get(WIKI_PATH, WIKI_FILE_NAME), gson.toJson(items).getBytes(Charsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException | IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

