/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.utils;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;

public class PlaceableItemsFluidUtil {
    public static FluidActionResult tryVirtualPickUpFluid(@Nonnull ItemStack emptyContainer, @Nullable PlayerEntity playerIn, World worldIn, BlockPos pos, Direction side) {
        FluidBlockWrapper targetFluidHandler;
        if (emptyContainer.func_190926_b() || worldIn == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        BlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            targetFluidHandler = new FluidBlockWrapper((IFluidBlock)block, worldIn, pos);
        } else if (block instanceof IBucketPickupHandler) {
            targetFluidHandler = new BucketPickupHandlerWrapper((IBucketPickupHandler)block, worldIn, pos);
        } else {
            Optional fluidHandler = FluidUtil.getFluidHandler((World)worldIn, (BlockPos)pos, (Direction)side).resolve();
            if (!fluidHandler.isPresent()) {
                return FluidActionResult.FAILURE;
            }
            targetFluidHandler = (IFluidHandler)fluidHandler.get();
        }
        return FluidUtil.tryFillContainer((ItemStack)emptyContainer, (IFluidHandler)targetFluidHandler, (int)Integer.MAX_VALUE, (PlayerEntity)playerIn, (boolean)false);
    }
}

