/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.rendering;

import java.util.List;
import java.util.function.Function;
import me.ferdz.placeableitems.rendering.PlaceableItemsBakedModel;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoaderRegistry;

public class PlaceableItemsModelGeometry
extends ModelLoaderRegistry.VanillaProxy {
    PlaceableItemsModelGeometry(List<BlockPart> list) {
        super(list);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        Simple builder = new Simple(new PlaceableItemsBakedModel.Builder(owner, overrides).setTexture(particle));
        this.addQuads(owner, builder, bakery, spriteGetter, modelTransform, modelLocation);
        return builder.build();
    }

    static class Simple
    implements IModelBuilder<Simple> {
        final PlaceableItemsBakedModel.Builder builder;

        Simple(PlaceableItemsBakedModel.Builder builder) {
            this.builder = builder;
        }

        public Simple addFaceQuad(Direction facing, BakedQuad quad) {
            this.builder.addFaceQuad(facing, quad);
            return this;
        }

        public Simple addGeneralQuad(BakedQuad quad) {
            this.builder.addGeneralQuad(quad);
            return this;
        }

        public IBakedModel build() {
            return this.builder.build();
        }
    }
}

