/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.init;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.function.Supplier;
import me.ferdz.placeableitems.tileentity.FluidHolderTileEntity;
import me.ferdz.placeableitems.tileentity.StackHolderTileEntity;
import me.ferdz.placeableitems.tileentity.SyncedStackHolderTileEntity;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class PlaceableItemsTileEntityTypeRegistry {
    private static final Multimap<Class<? extends TileEntity>, Block> VALID_BLOCKS = MultimapBuilder.hashKeys().arrayListValues().build();

    private PlaceableItemsTileEntityTypeRegistry() {
    }

    @SubscribeEvent
    public static void registerTE(RegistryEvent.Register<TileEntityType<?>> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{(TileEntityType)PlaceableItemsTileEntityTypeRegistry.registerWithBlocks(StackHolderTileEntity::new, StackHolderTileEntity.class).setRegistryName("placeableitems", "writable_book_block"), (TileEntityType)PlaceableItemsTileEntityTypeRegistry.registerWithBlocks(SyncedStackHolderTileEntity::new, SyncedStackHolderTileEntity.class).setRegistryName("placeableitems", "placeableitems_synced_stackholder"), (TileEntityType)PlaceableItemsTileEntityTypeRegistry.registerWithBlocks(FluidHolderTileEntity::new, FluidHolderTileEntity.class).setRegistryName("placeableitems", "fluid_holder")});
    }

    public static void assignTo(Class<? extends TileEntity> tileEntity, Block block) {
        VALID_BLOCKS.put(tileEntity, (Object)block);
    }

    private static <T extends TileEntity> TileEntityType<T> registerWithBlocks(Supplier<T> factory, Class<T> tileClass) {
        Collection validBlocks = VALID_BLOCKS.removeAll(tileClass);
        TileEntityType type = TileEntityType.Builder.func_223042_a(factory, (Block[])validBlocks.toArray(new Block[validBlocks.size()])).func_206865_a(null);
        return type;
    }
}

