/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.client;

import me.ferdz.placeableitems.init.PlaceableItemsBlockRegistry;
import me.ferdz.placeableitems.rendering.PlaceableItemsModelLoader;
import me.ferdz.placeableitems.tileentity.StackHolderTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public class ClientSetup {
    public static void setup() {
        ClientSetup clientSetup = new ClientSetup();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(clientSetup::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(clientSetup::onModelRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(clientSetup::onColorSetup);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
    }

    private void onModelRegistry(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("placeableitems", "rotation"), (IModelLoader)new PlaceableItemsModelLoader());
    }

    private void onColorSetup(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a(ClientSetup::getPotionColor, new Block[]{PlaceableItemsBlockRegistry.POTION});
        event.getBlockColors().func_186722_a(ClientSetup::getPotionColor, new Block[]{PlaceableItemsBlockRegistry.LINGERING_POTION});
        event.getBlockColors().func_186722_a(ClientSetup::getPotionColor, new Block[]{PlaceableItemsBlockRegistry.SPLASH_POTION});
    }

    private static int getPotionColor(BlockState blockState, IBlockDisplayReader blockDisplayReader, BlockPos pos, int index) {
        StackHolderTileEntity tileEntity;
        if (pos != null && blockDisplayReader != null && (tileEntity = (StackHolderTileEntity)blockDisplayReader.func_175625_s(pos)) != null) {
            ItemStack itemStack = tileEntity.getItemStack();
            return PotionUtils.func_190932_c((ItemStack)itemStack);
        }
        return 3694022;
    }
}

