/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.client;

import java.util.UUID;
import me.ferdz.placeableitems.PlaceableItems;
import me.ferdz.placeableitems.event.ItemPlaceHandler;
import me.ferdz.placeableitems.network.CNotifyItemPlaceKeyPacket;
import me.ferdz.placeableitems.network.PlaceableItemsPacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class ClientListener {
    private static final ClientListener INSTANCE = new ClientListener();
    private static final KeyBinding KEY_BINDING_PLACE_ITEM = new KeyBinding("key.placeableitems.place_item", 340, "key.categories.placeableitems");
    private boolean registeredListeners = false;

    private ClientListener() {
    }

    void onClientSetup(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_BINDING_PLACE_ITEM);
    }

    void onKeyPress(InputEvent.KeyInputEvent event) {
        int action = event.getAction();
        if (action == 2 || event.getKey() != KEY_BINDING_PLACE_ITEM.getKey().func_197937_c()) {
            return;
        }
        if (Minecraft.func_71410_x().func_147114_u() == null || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ItemPlaceHandler placeHandler = PlaceableItems.getInstance().getPlaceHandler();
        boolean pressed = action == 1;
        UUID playerId = Minecraft.func_71410_x().field_71439_g.func_110124_au();
        if (placeHandler.isHoldingKey(playerId) == pressed) {
            return;
        }
        PlaceableItemsPacketHandler.INSTANCE.sendToServer((Object)new CNotifyItemPlaceKeyPacket(pressed));
        placeHandler.setHoldingKey(playerId, pressed);
    }

    public static ClientListener get() {
        ClientListener instance = INSTANCE;
        if (!instance.registeredListeners) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(instance::onClientSetup);
            MinecraftForge.EVENT_BUS.addListener(instance::onKeyPress);
            instance.registeredListeners = true;
        }
        return instance;
    }
}

