/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block.component.impl;

import java.util.Collections;
import java.util.List;
import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import me.ferdz.placeableitems.wiki.WikiBlockComponentDefinition;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

@WikiBlockComponentDefinition(description="Right click this block with more of the same item to add to the stack")
public class StackableBlockComponent
extends AbstractBlockComponent {
    private final int maxCount;
    private final IntegerProperty filled;

    public StackableBlockComponent(int maxCount) {
        this.maxCount = maxCount;
        this.filled = IntegerProperty.func_177719_a((String)"count", (int)1, (int)maxCount);
    }

    @Override
    public boolean use(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        int count = (Integer)state.func_177229_b((Property)this.filled);
        ItemStack heldItemStack = player.func_184586_b(handIn);
        Item heldItem = heldItemStack.func_77973_b();
        if (heldItem == Items.field_190931_a) {
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)state.func_177230_c().func_199767_j(), 1));
            if (count == 1) {
                worldIn.func_225521_a_(pos, false, (Entity)player);
            } else {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)this.filled, (Comparable)Integer.valueOf(count - 1)));
            }
            return true;
        }
        if (heldItem == state.func_177230_c().func_199767_j()) {
            if (count == this.maxCount) {
                return false;
            }
            if (!player.func_184812_l_()) {
                heldItemStack.func_190918_g(1);
            }
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)this.filled, (Comparable)Integer.valueOf(count + 1)));
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootContext.Builder builder) {
        int count = (Integer)state.func_177229_b((Property)this.filled);
        return Collections.singletonList(new ItemStack((IItemProvider)state.func_177230_c().func_199767_j(), count));
    }

    @Override
    public void createBlockStateDefinition(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.filled});
    }

    @Override
    public IFormattableTextComponent getDescription(ItemStack itemStack) {
        return new TranslationTextComponent("key.placeableitems.component.stackable", new Object[]{itemStack.func_77973_b().func_200296_o()});
    }
}

