/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block.component.impl;

import java.util.Collections;
import java.util.List;
import me.ferdz.placeableitems.block.PlaceableItemsBlock;
import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import me.ferdz.placeableitems.init.PlaceableItemsMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;

public class MusicDiscBlockComponent
extends AbstractBlockComponent {
    private static final EnumProperty<MusicDiscType> DISC_TYPE = EnumProperty.func_177709_a((String)"disc_type", MusicDiscType.class);

    @Override
    public void register(PlaceableItemsBlock block, String name) {
        for (MusicDiscType musicDiscType : MusicDiscType.values()) {
            PlaceableItemsMap.instance().put(musicDiscType.item, block);
        }
    }

    @Override
    public void createBlockStateDefinition(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DISC_TYPE});
    }

    @Override
    public BlockState getStateForPlacement(BlockItemUseContext context, BlockState blockState) {
        Item item = context.func_195996_i().func_77973_b();
        for (MusicDiscType musicDiscType : MusicDiscType.values()) {
            if (musicDiscType.item != item) continue;
            return (BlockState)blockState.func_206870_a(DISC_TYPE, (Comparable)((Object)musicDiscType));
        }
        return blockState;
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootContext.Builder builder) {
        return Collections.singletonList(new ItemStack((IItemProvider)((MusicDiscType)((Object)state.func_177229_b(DISC_TYPE))).item));
    }

    @Override
    public Item asItem() {
        return Items.field_196156_dS;
    }

    @Override
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)((MusicDiscType)((Object)state.func_177229_b(DISC_TYPE))).item);
    }

    public static enum MusicDiscType implements IStringSerializable
    {
        MUSIC_DISC_11("11", Items.field_196189_ec),
        MUSIC_DISC_13("13", Items.field_196156_dS),
        MUSIC_DISC_BLOCKS("blocks", Items.field_196160_dU),
        MUSIC_DISC_CAT("cat", Items.field_196158_dT),
        MUSIC_DISC_CHIRP("chirp", Items.field_196162_dV),
        MUSIC_DISC_FAR("far", Items.field_196164_dW),
        MUSIC_DISC_MALL("mall", Items.field_196166_dX),
        MUSIC_DISC_MELLOHI("mellohi", Items.field_196168_dY),
        MUSIC_DISC_STAL("stal", Items.field_196170_dZ),
        MUSIC_DISC_STRAD("strad", Items.field_196187_ea),
        MUSIC_DISC_WARD("ward", Items.field_196188_eb),
        MUSIC_DISC_WAIT("wait", Items.field_196190_ed);

        private final String name;
        private final Item item;

        private MusicDiscType(String p_i49342_3_, Item item) {
            this.name = p_i49342_3_;
            this.item = item;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public Item getItem() {
            return this.item;
        }
    }
}

