/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block.component.impl;

import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import me.ferdz.placeableitems.wiki.WikiBlockComponentDefinition;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

@WikiBlockComponentDefinition(description="This item has many models. Right click to cycle through them")
public class MultiModelBlockComponent
extends AbstractBlockComponent {
    private final int maxCount;
    private final IntegerProperty model;

    public MultiModelBlockComponent(int maxCount) {
        this.maxCount = maxCount;
        this.model = IntegerProperty.func_177719_a((String)"model", (int)0, (int)maxCount);
    }

    @Override
    public boolean use(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        int nextModel = (Integer)state.func_177229_b((Property)this.model) + 1;
        if (nextModel > this.maxCount) {
            nextModel = 0;
        }
        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)this.model, (Comparable)Integer.valueOf(nextModel)));
        return true;
    }

    @Override
    public void createBlockStateDefinition(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.model});
    }

    @Override
    public IFormattableTextComponent getDescription(ItemStack itemStack) {
        return new TranslationTextComponent("key.placeableitems.component.multimodel", new Object[]{new StringTextComponent(String.valueOf(this.maxCount + 1))});
    }
}

