/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block.component.impl;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import me.ferdz.placeableitems.wiki.WikiBlockComponentDefinition;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

@WikiBlockComponentDefinition(description="Right clicking this block will have a chance to drop an item")
public class ItemStackSourceBlockComponent
extends AbstractBlockComponent {
    private final float chance;
    private final Supplier<ItemStack> itemSupplier;

    public ItemStackSourceBlockComponent(float chance, Supplier<ItemStack> itemSupplier) {
        Preconditions.checkArgument((itemSupplier != null ? 1 : 0) != 0, (Object)"Item supplier must not be null");
        this.chance = chance;
        this.itemSupplier = itemSupplier;
    }

    public ItemStackSourceBlockComponent(Supplier<ItemStack> itemSupplier) {
        this(1.0f, itemSupplier);
    }

    @Override
    public boolean use(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack;
        if (worldIn.field_72995_K) {
            return true;
        }
        if (worldIn.field_73012_v.nextFloat() < this.chance && (stack = this.itemSupplier.get()) != null && !stack.func_190926_b()) {
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
        return true;
    }
}

