/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block.component.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import me.ferdz.placeableitems.wiki.WikiBlockComponentDefinition;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

@WikiBlockComponentDefinition(description="Right clicking this block will have a chance to spawn an entity")
public class EntitySourceBlockComponent
extends AbstractBlockComponent {
    private final float chance;
    private final Function<World, ? extends Entity> entitySupplier;

    public EntitySourceBlockComponent(float chance, Function<World, ? extends Entity> entitySupplier) {
        Preconditions.checkArgument((entitySupplier != null ? 1 : 0) != 0, (Object)"Entity supplier must not be null");
        this.chance = chance;
        this.entitySupplier = entitySupplier;
    }

    public EntitySourceBlockComponent(Function<World, ? extends Entity> entitySupplier) {
        this(1.0f, entitySupplier);
    }

    @Override
    public boolean use(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        Entity entity;
        if (worldIn.field_72995_K) {
            return true;
        }
        if (worldIn.field_73012_v.nextFloat() < this.chance && (entity = (Entity)this.entitySupplier.apply((Object)worldIn)) != null) {
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            worldIn.func_217376_c(entity);
        }
        return true;
    }
}

