/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block;

import java.util.ArrayList;
import java.util.List;
import me.ferdz.placeableitems.block.PlaceableItemsBlock;
import me.ferdz.placeableitems.block.component.IBlockComponent;
import me.ferdz.placeableitems.init.PlaceableItemsTileEntityTypeRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;

public class PlaceableItemsBlockBuilder {
    private List<IBlockComponent> components = new ArrayList<IBlockComponent>();
    private int lightLevel;

    public PlaceableItemsBlockBuilder addComponent(IBlockComponent component) {
        this.components.add(component);
        return this;
    }

    public PlaceableItemsBlockBuilder setLightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
        return this;
    }

    public PlaceableItemsBlock build() {
        PlaceableItemsBlock block = new PlaceableItemsBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_226896_b_().func_235838_a_(state -> this.lightLevel)){

            @Override
            protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                for (IBlockComponent component : PlaceableItemsBlockBuilder.this.components) {
                    component.createBlockStateDefinition(builder);
                }
            }
        }.addComponents(this.components);
        block.getComponents().forEach(component -> {
            Class<? extends TileEntity> tileEntityClass = component.getTileEntityClass(null);
            if (tileEntityClass != null) {
                PlaceableItemsTileEntityTypeRegistry.assignTo(tileEntityClass, block);
            }
        });
        return block;
    }
}

