/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import me.ferdz.placeableitems.block.component.IBlockComponent;
import me.ferdz.placeableitems.init.PlaceableItemsMap;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PlaceableItemsBlock
extends Block {
    public static final IntegerProperty ROTATION = BlockStateProperties.field_208138_am;
    @Nullable
    private Item item;
    private BlockItem blockItem;
    private VoxelShape shape = VoxelShapes.func_197868_b();
    private List<IBlockComponent> components = new ArrayList<IBlockComponent>();

    public PlaceableItemsBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public PlaceableItemsBlock register(String name, IForgeRegistry<Block> registry) {
        this.setRegistryName("placeableitems", name);
        registry.register((IForgeRegistryEntry)this);
        for (IBlockComponent component : this.components) {
            component.register(this, name);
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> RenderTypeLookup.setRenderLayer((Block)this.getBlock(), (RenderType)RenderType.func_228643_e_()));
        return this;
    }

    public PlaceableItemsBlock register(String name, Item item, IForgeRegistry<Block> registry) {
        this.item = item;
        PlaceableItemsMap.instance().put(item, this);
        this.register(name, registry);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> RenderTypeLookup.setRenderLayer((Block)this.getBlock(), (RenderType)RenderType.func_228643_e_()));
        return this;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        for (IBlockComponent component : this.components) {
            component.setPlacedBy(worldIn, pos, state, placer, stack);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockState = (BlockState)this.func_176223_P().func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(MathHelper.func_76128_c((double)((double)(context.func_195990_h() * 16.0f / 360.0f) + 0.5)) & 0xF));
        for (IBlockComponent component : this.components) {
            blockState = component.getStateForPlacement(context, blockState);
        }
        return blockState;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot.func_185833_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(mirrorIn.func_185802_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ROTATION});
    }

    public Item func_199767_j() {
        for (IBlockComponent component : this.components) {
            Item item = component.asItem();
            if (item == null) continue;
            return item;
        }
        return this.item;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        for (IBlockComponent component : this.components) {
            ItemStack itemStack = component.getPickBlock(state, target, world, pos, player);
            if (itemStack == null) continue;
            return itemStack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public BlockItem getBlockItem() {
        if (this.blockItem == null) {
            this.blockItem = new BlockItem((Block)this, new Item.Properties());
        }
        return this.blockItem;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (IBlockComponent component : this.components) {
            itemStacks.addAll(component.getDrops(state, builder));
        }
        if (!itemStacks.isEmpty()) {
            return itemStacks;
        }
        if (this.func_199767_j() != null) {
            itemStacks.add(new ItemStack((IItemProvider)this.func_199767_j()));
        }
        return itemStacks;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        for (IBlockComponent component : this.components) {
            VoxelShape shape = component.getShape(this.shape, state, worldIn, pos, context);
            if (shape == null) continue;
            return shape;
        }
        return this.shape;
    }

    public PlaceableItemsBlock setShape(VoxelShape shape) {
        this.shape = shape;
        return this;
    }

    public VoxelShape getShape() {
        return this.shape;
    }

    public boolean hasTileEntity(BlockState state) {
        for (IBlockComponent component : this.components) {
            if (!component.hasTileEntity(state)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        for (IBlockComponent component : this.components) {
            TileEntity tileEntity = component.createTileEntity(state, world);
            if (tileEntity == null) continue;
            return tileEntity;
        }
        return null;
    }

    private PlaceableItemsBlock addComponent(IBlockComponent component) {
        this.components.add(component);
        return this;
    }

    PlaceableItemsBlock addComponents(Iterable<IBlockComponent> components) {
        for (IBlockComponent component : components) {
            this.addComponent(component);
        }
        return this;
    }

    public List<IBlockComponent> getComponents() {
        return this.components;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean hadAnImplementation = false;
        for (IBlockComponent component : this.components) {
            try {
                component.use(state, worldIn, pos, player, handIn, hit);
                hadAnImplementation = true;
            }
            catch (AbstractBlockComponent.NotImplementedException notImplementedException) {}
        }
        if (!hadAnImplementation) {
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        boolean hadAnImplementation = false;
        for (IBlockComponent component : this.components) {
            try {
                component.updateEntityAfterFallOn(worldIn, entityIn);
                hadAnImplementation = true;
            }
            catch (AbstractBlockComponent.NotImplementedException notImplementedException) {}
        }
        if (!hadAnImplementation) {
            super.func_176216_a(worldIn, entityIn);
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        boolean hadAnImplementation = false;
        for (IBlockComponent component : this.components) {
            try {
                component.fallOn(worldIn, pos, entityIn, fallDistance);
                hadAnImplementation = true;
            }
            catch (AbstractBlockComponent.NotImplementedException notImplementedException) {}
        }
        if (!hadAnImplementation) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random random) {
        for (IBlockComponent component : this.components) {
            component.animateTick(stateIn, worldIn, pos, random);
        }
    }
}

