/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.tesla_coil;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoil;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBeltCallbacks;
import com.mrh0.createaddition.compat.applied_energistics.AE2;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CAEffects;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.item.ChargingChromaticCompound;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TeslaCoilTileEntity
extends BaseElectricTileEntity
implements IHaveGoggleInformation {
    private static final int MAX_IN = (Integer)Config.TESLA_COIL_MAX_INPUT.get();
    private static final int CHARGE_RATE = (Integer)Config.TESLA_COIL_CHARGE_RATE.get();
    private static final int CAPACITY = Math.max((Integer)Config.TESLA_COIL_CAPACITY.get(), CHARGE_RATE);
    private static final int HURT_ENERGY_REQUIRED = (Integer)Config.TESLA_COIL_HURT_ENERGY_REQUIRED.get();
    private static final int HURT_DMG_MOB = (Integer)Config.TESLA_COIL_HURT_DMG_MOB.get();
    private static final int HURT_DMG_PLAYER = (Integer)Config.TESLA_COIL_HURT_DMG_PLAYER.get();
    private static final int HURT_RANGE = (Integer)Config.TESLA_COIL_HURT_RANGE.get();
    private static final int HURT_EFFECT_TIME_MOB = (Integer)Config.TESLA_COIL_HURT_EFFECT_TIME_MOB.get();
    private static final int HURT_EFFECT_TIME_PLAYER = (Integer)Config.TESLA_COIL_HURT_EFFECT_TIME_PLAYER.get();
    private static final int HURT_FIRE_COOLDOWN = (Integer)Config.TESLA_COIL_HURT_FIRE_COOLDOWN.get();
    private static final float CERTUS_QUARTZ_CHANCE = (float)((Double)Config.CERTUS_QUARTZ_CHARGE_CHANCE.get()).doubleValue();
    protected ItemStack chargedStackCache;
    protected int poweredTimer = 0;
    private static DamageSource dmgSource = new DamageSource("tesla_coil");
    public BeltProcessingBehaviour processingBehaviour;
    int dmgTick = 0;

    public TeslaCoilTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, CAPACITY, MAX_IN, 0);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.processingBehaviour = new BeltProcessingBehaviour((SmartTileEntity)this).whenItemEnters((s, i) -> TeslaCoilBeltCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> TeslaCoilBeltCallbacks.whenItemHeld(s, i, this));
        behaviours.add((TileEntityBehaviour)this.processingBehaviour);
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return side != this.func_195044_w().func_177229_b((Property)TeslaCoil.FACING);
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    public int getConsumption() {
        return CHARGE_RATE;
    }

    protected float getItemCharge(IEnergyStorage energy) {
        if (energy == null) {
            return 0.0f;
        }
        return (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored();
    }

    public float getCharge(ItemStack itemStack) {
        if (this.chargedStackCache != null) {
            return 0.0f;
        }
        if (itemStack.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
            return this.getItemCharge((IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY).orElse(null));
        }
        if (itemStack.func_77973_b() == CAItems.CHARGING_CHROMATIC_COMPOUND.get()) {
            return (float)ChargingChromaticCompound.getCharge(itemStack) * 90.0f;
        }
        if (itemStack.func_77973_b() == CAItems.OVERCHARGED_ALLOY.get()) {
            return 90.0f;
        }
        return 0.0f;
    }

    public String getChargeString() {
        float c = Math.round(this.getCharge(this.chargedStackCache) * 100.0f);
        if (c >= 9000.0f) {
            return "OVER9000% ";
        }
        return Math.round(this.getCharge(this.chargedStackCache) * 100.0f) + "% ";
    }

    protected BeltProcessingBehaviour.ProcessingResult onCharge(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        BeltProcessingBehaviour.ProcessingResult res = this.chargeCompundAndStack(transported, handler);
        return res;
    }

    private void doDmg() {
        this.energy.internalConsumeEnergy(HURT_ENERGY_REQUIRED);
        BlockPos origin = this.func_174877_v().func_177972_a(((Direction)this.func_195044_w().func_177229_b((Property)TeslaCoil.FACING)).func_176734_d());
        List ents = this.getWorld().func_217357_a(LivingEntity.class, new AxisAlignedBB(origin).func_186662_g((double)HURT_RANGE));
        for (LivingEntity e : ents) {
            int dmg = HURT_DMG_MOB;
            int time = HURT_EFFECT_TIME_MOB;
            if (e instanceof PlayerEntity) {
                dmg = HURT_DMG_PLAYER;
                time = HURT_EFFECT_TIME_PLAYER;
            }
            if (dmg > 0) {
                e.func_70097_a(dmgSource, (float)dmg);
            }
            if (time <= 0) continue;
            e.func_195064_c(new EffectInstance(CAEffects.SHOCKING, time));
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        int signal = this.getWorld().func_175687_A(this.func_174877_v());
        if (signal > 0 && this.energy.getEnergyStored() >= HURT_ENERGY_REQUIRED) {
            this.poweredTimer = 10;
        }
        ++this.dmgTick;
        if ((this.dmgTick %= HURT_FIRE_COOLDOWN) == 0 && this.energy.getEnergyStored() >= HURT_ENERGY_REQUIRED && signal > 0) {
            this.doDmg();
        }
        if (this.poweredTimer > 0) {
            if (!this.shouldPower(signal)) {
                ((TeslaCoil)CABlocks.TESLA_COIL.get()).setPowered(this.field_145850_b, this.func_174877_v(), true);
            }
            --this.poweredTimer;
        } else if (this.shouldPower(signal)) {
            ((TeslaCoil)CABlocks.TESLA_COIL.get()).setPowered(this.field_145850_b, this.func_174877_v(), false);
        }
    }

    public boolean shouldPower(int signal) {
        return (Boolean)this.func_195044_w().func_177229_b((Property)TeslaCoil.POWERED);
    }

    protected BeltProcessingBehaviour.ProcessingResult chargeCompundAndStack(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        ItemStack stack = transported.stack;
        if (stack == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (stack.func_77973_b() == AllItems.CHROMATIC_COMPOUND.get()) {
            TransportedItemStack res = new TransportedItemStack(new ItemStack((IItemProvider)CAItems.CHARGING_CHROMATIC_COMPOUND.get(), stack.func_190916_E()));
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo((TransportedItemStack)res));
        }
        if (this.chargeStack(stack, transported, handler)) {
            if (this.energy.getEnergyStored() >= stack.func_190916_E()) {
                this.poweredTimer = 10;
            }
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.chargeAE2(stack, transported, handler)) {
            if (this.energy.getEnergyStored() >= CHARGE_RATE) {
                this.poweredTimer = 10;
            }
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (stack.func_77973_b() == CAItems.CHARGING_CHROMATIC_COMPOUND.get()) {
            if (this.energy.getEnergyStored() >= stack.func_190916_E()) {
                this.poweredTimer = 10;
            }
            int energyPush = Math.min(this.energy.getEnergyStored(), this.getConsumption()) / stack.func_190916_E();
            int energyRemoved = ChargingChromaticCompound.charge(stack, energyPush);
            this.energy.internalConsumeEnergy(energyRemoved * stack.func_190916_E());
            if (ChargingChromaticCompound.getEnergy(stack) >= ChargingChromaticCompound.MAX_CHARGE) {
                TransportedItemStack res = new TransportedItemStack(new ItemStack((IItemProvider)CAItems.OVERCHARGED_ALLOY.get(), stack.func_190916_E()));
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo((TransportedItemStack)res));
            }
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        return BeltProcessingBehaviour.ProcessingResult.PASS;
    }

    protected boolean chargeStack(ItemStack stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (!stack.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
            return false;
        }
        IEnergyStorage es = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        if (es.receiveEnergy(1, true) != 1) {
            return false;
        }
        int r = this.energy.internalConsumeEnergy(es.receiveEnergy(Math.min(this.getConsumption(), this.energy.getEnergyStored()), false));
        return true;
    }

    protected boolean chargeAE2(ItemStack stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (!CreateAddition.AE2_ACTIVE) {
            return false;
        }
        if (!AE2.isCertusQuartz(stack)) {
            return false;
        }
        int energyRemoved = this.energy.internalConsumeEnergy(this.getConsumption());
        if (energyRemoved >= this.getConsumption() && this.field_145850_b.field_73012_v.nextFloat() > CERTUS_QUARTZ_CHANCE) {
            TransportedItemStack left = transported.copy();
            left.stack.func_190918_g(1);
            ArrayList r = new ArrayList();
            AE2.getChargedCertusQuartz(1).ifPresent(is -> r.add(new TransportedItemStack(is)));
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(r, (TransportedItemStack)left));
        }
        return true;
    }
}

