/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.links;

import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class Link {
    public static final String FORMAT = TextFormatting.ITALIC.toString() + TextFormatting.UNDERLINE.toString();
    private final List<String> parts;
    @Nullable
    private final ResourceLocation target;
    private final String targetAnchor;
    private final int targetOffset;

    public Link(List<String> parts, @Nullable ResourceLocation target, String targetAnchor, int offset) {
        this.parts = parts;
        this.target = target;
        this.targetOffset = offset;
        this.targetAnchor = targetAnchor;
    }

    public Link(String text, String target, String targetInEntry, ManualInstance manual) {
        String[] resultParts;
        ArrayList<String> parts = new ArrayList<String>();
        for (String resultPart : resultParts = text.split("(?<= )")) {
            String part = FORMAT + resultPart;
            parts.add(part);
        }
        int last = parts.size() - 1;
        parts.set(last, (String)parts.get(last) + TextFormatting.RESET);
        this.target = "this".equals(target) ? null : ManualUtils.getLocationForManual(target, manual);
        this.parts = ImmutableList.copyOf(parts);
        if (targetInEntry.contains("+")) {
            try {
                int plus = targetInEntry.indexOf(43);
                this.targetAnchor = targetInEntry.substring(0, plus);
                this.targetOffset = Integer.parseInt(targetInEntry.substring(plus + 1));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else {
            this.targetAnchor = targetInEntry;
            this.targetOffset = 0;
        }
    }

    public List<String> getParts() {
        return this.parts;
    }

    public String getTargetAnchor() {
        return this.targetAnchor;
    }

    public ResourceLocation getTarget(ManualEntry fromEntry) {
        return this.target == null ? fromEntry.getLocation() : this.target;
    }

    public int getTargetOffset() {
        return this.targetOffset;
    }

    @Nullable
    public ResourceLocation getRawTarget() {
        return this.target;
    }
}

