/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions;

import blusunrize.immersiveengineering.common.crafting.GeneratedListRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl_native.fluid.ExpandFluid;
import java.util.Iterator;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipe;

public abstract class AbstractActionGenericRemoveRecipe<T extends IRecipe<?>>
implements IRuntimeAction {
    private final IRecipeManager manager;
    private final String output;

    public AbstractActionGenericRemoveRecipe(IRecipeManager manager, CommandStringDisplayable output) {
        this(manager, output.getCommandString());
    }

    public AbstractActionGenericRemoveRecipe(IRecipeManager manager, Fluid fluid) {
        this(manager, ExpandFluid.getCommandString((Fluid)fluid));
    }

    public AbstractActionGenericRemoveRecipe(IRecipeManager manager, String output) {
        this.manager = manager;
        this.output = output;
    }

    public void apply() {
        int count = 0;
        Iterator iterator = this.manager.getRecipes().entrySet().iterator();
        try {
            while (iterator.hasNext()) {
                IRecipe recipe = (IRecipe)iterator.next().getValue();
                if (recipe instanceof GeneratedListRecipe) {
                    CraftTweakerAPI.logDebug((String)"Skipping GeneratedListRecipe '%s'", (Object[])new Object[]{recipe.func_199560_c()});
                    continue;
                }
                if (!this.shouldRemove(recipe)) continue;
                iterator.remove();
                ++count;
            }
        }
        catch (ClassCastException exception) {
            CraftTweakerAPI.logThrowing((String)"There is an illegal entry in %s that caused an exception: ", (Throwable)exception, (Object[])new Object[]{this.manager.getCommandString()});
        }
        CraftTweakerAPI.logInfo((String)"Removed %s \"%s\" recipes", (Object[])new Object[]{count, this.manager.getCommandString()});
    }

    public abstract boolean shouldRemove(T var1);

    public String describe() {
        return "Removing all \"" + this.manager.getCommandString() + "\" recipes, that output: " + this.output;
    }
}

