/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.commands.CTCommandCollectionEvent;
import com.blamejared.crafttweaker.impl.commands.script_examples.ExampleCollectionEvent;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CrafttweakerEventHandlers {
    @SubscribeEvent
    public static void onCommandCollection(CTCommandCollectionEvent event) {
        event.registerDump("ieBlueprintCategories", "Lists the different blueprint categories for the IE workbench", commandContext -> {
            CraftTweakerAPI.logDump((String)"List of all known blueprint categories: ", (Object[])new Object[0]);
            for (String recipeCategory : BlueprintCraftingRecipe.recipeCategories) {
                CraftTweakerAPI.logDump((String)"- %s", (Object[])new Object[]{recipeCategory});
            }
            StringTextComponent message = new StringTextComponent(TextFormatting.GREEN + "Categories written to the log" + TextFormatting.RESET);
            ((CommandSource)commandContext.getSource()).func_197030_a((ITextComponent)message, true);
            return 0;
        });
    }

    @SubscribeEvent
    public static void onExampleEvent(ExampleCollectionEvent event) {
        CrafttweakerEventHandlers.addExampleFile(event, "alloy");
        CrafttweakerEventHandlers.addExampleFile(event, "arc_furnace");
        CrafttweakerEventHandlers.addExampleFile(event, "blast_furnace");
        CrafttweakerEventHandlers.addExampleFile(event, "blueprint");
        CrafttweakerEventHandlers.addExampleFile(event, "bottling_machine");
        CrafttweakerEventHandlers.addExampleFile(event, "cloche");
        CrafttweakerEventHandlers.addExampleFile(event, "coke_oven");
        CrafttweakerEventHandlers.addExampleFile(event, "crusher");
        CrafttweakerEventHandlers.addExampleFile(event, "fermenter");
        CrafttweakerEventHandlers.addExampleFile(event, "metal_press");
        CrafttweakerEventHandlers.addExampleFile(event, "mineral_mix");
        CrafttweakerEventHandlers.addExampleFile(event, "mixer");
        CrafttweakerEventHandlers.addExampleFile(event, "refinery");
        CrafttweakerEventHandlers.addExampleFile(event, "sawmill");
        CrafttweakerEventHandlers.addExampleFile(event, "squeezer");
    }

    private static void addExampleFile(ExampleCollectionEvent event, String scriptName) {
        event.addResource(new ResourceLocation("immersiveengineering", "immersiveengineering/" + scriptName));
    }
}

