/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class RevolvershotFlareEntity
extends RevolvershotEntity {
    public static final EntityType<RevolvershotFlareEntity> TYPE = EntityType.Builder.func_220322_a(RevolvershotFlareEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.125f, 0.125f).func_206830_a("immersiveengineering:revolver_shot_flare");
    public int colour = -1;
    private static final DataParameter<Integer> dataMarker_colour;
    private BlockPos lightPos;

    public RevolvershotFlareEntity(EntityType<RevolvershotFlareEntity> type, World world) {
        super((EntityType<? extends RevolvershotEntity>)type, world);
        this.setTickLimit(400);
    }

    public RevolvershotFlareEntity(World world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super(TYPE, world, null, x, y, z, ax, ay, az, type);
        this.setTickLimit(400);
    }

    public RevolvershotFlareEntity(World world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type, ItemStack stack) {
        super(TYPE, world, living, ax, ay, az, type);
        this.setTickLimit(400);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataMarker_colour, (Object)-1);
    }

    public void setColourSynced() {
        this.field_70180_af.func_187227_b(dataMarker_colour, (Object)this.colour);
    }

    public int getColourSynced() {
        return (Integer)this.field_70180_af.func_187225_a(dataMarker_colour);
    }

    public int getColour() {
        return this.colour;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.colour < 0) {
            this.colour = this.getColourSynced();
        }
        if (this.field_70170_p.field_72995_K) {
            float r = (float)(this.getColour() >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.getColour() >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.getColour() & 0xFF) / 255.0f;
            ImmersiveEngineering.proxy.spawnRedstoneFX(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0, 1.0f, r, g, b);
            if (this.field_70173_aa > 40) {
                for (int i = 0; i < 20; ++i) {
                    Vector3d v = new Vector3d(Utils.RAND.nextDouble() - 0.5, Utils.RAND.nextDouble() - 0.5, Utils.RAND.nextDouble() - 0.5);
                    ImmersiveEngineering.proxy.spawnRedstoneFX(this.field_70170_p, this.func_226277_ct_() + v.field_72450_a, this.func_226278_cu_() + v.field_72448_b, this.func_226281_cx_() + v.field_72449_c, v.field_72450_a / 10.0, v.field_72448_b / 10.0, v.field_72449_c / 10.0, 1.0f, r, g, b);
                }
            }
        }
        if (this.field_70173_aa == 40) {
            this.func_213293_j(0.0, -0.1, 0.0);
            this.spawnParticles();
            this.lightPos = this.func_233580_cy_();
            for (int i = 0; i < 128; ++i) {
                if (!this.field_70170_p.func_175623_d(this.lightPos)) {
                    this.lightPos = this.lightPos.func_177981_b(6);
                    break;
                }
                this.lightPos = this.lightPos.func_177977_b();
            }
        }
    }

    @Override
    public void func_70227_a(RayTraceResult mop) {
        if (this.field_70173_aa <= 40) {
            if (!this.field_70170_p.field_72995_K) {
                BlockRayTraceResult blockRTR;
                BlockPos pos;
                if (mop instanceof EntityRayTraceResult) {
                    Entity hit = ((EntityRayTraceResult)mop).func_216348_a();
                    if (!hit.func_230279_az_()) {
                        hit.func_70015_d(8);
                    }
                } else if (mop instanceof BlockRayTraceResult && this.field_70170_p.func_175623_d(pos = (blockRTR = (BlockRayTraceResult)mop).func_216350_a().func_177972_a(blockRTR.func_216354_b()))) {
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
            }
            this.spawnParticles();
        }
        this.func_70106_y();
    }

    private void spawnParticles() {
        float r = (float)(this.getColour() >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.getColour() >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.getColour() & 0xFF) / 255.0f;
        for (int i = 0; i < 80; ++i) {
            Vector3d v = new Vector3d((Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0);
            ImmersiveEngineering.proxy.spawnRedstoneFX(this.field_70170_p, this.func_226277_ct_() + v.field_72450_a, this.func_226278_cu_() + v.field_72448_b, this.func_226281_cx_() + v.field_72449_c, v.field_72450_a / 10.0, v.field_72448_b / 10.0, v.field_72449_c / 10.0, 1.0f, r, g, b);
        }
    }

    static {
        TYPE.setRegistryName("immersiveengineering", "revolver_shot_flare");
        dataMarker_colour = EntityDataManager.func_187226_a(RevolvershotFlareEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    }
}

