/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class SqueezerTileEntity
extends PoweredMultiblockTileEntity<SqueezerTileEntity, SqueezerRecipe>
implements IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IBlockBounds {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(24000)};
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)11, (Object)ItemStack.field_190927_a);
    public float animation_piston = 0.0f;
    public boolean animation_down = true;
    private CapabilityReference<IItemHandler> outputCap = CapabilityReference.forTileEntityAt(this, this::getOutputPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(SqueezerTileEntity::getShape);
    private LazyOptional<IItemHandler> insertionHandler = this.registerConstantCap(new IEInventoryHandler(8, (IIEInventory)this, 0, new boolean[]{true, true, true, true, true, true, true, true}, new boolean[8]));
    private LazyOptional<IItemHandler> extractionHandler = this.registerConstantCap(new IEInventoryHandler(1, (IIEInventory)this, 8, new boolean[1], new boolean[]{true}));
    private static final BlockPos inputOffset = new BlockPos(0, 1, 0);
    private static final BlockPos outputOffset = new BlockPos(1, 1, 1);

    public SqueezerTileEntity() {
        super(IEMultiblocks.SQUEEZER, 16000, true, (TileEntityType)IETileTypes.SQUEEZER.get());
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 11);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        CompoundNBT tankTag = this.tanks[0].writeToNBT(new CompoundNBT());
        nbt.func_218657_a("tank", (INBT)tankTag);
        if (!descPacket) {
            nbt.func_218657_a("inventory", (INBT)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.processQueue.isEmpty() && (double)this.animation_piston < 0.6875) {
                this.animation_piston = Math.min(0.6875f, this.animation_piston + 0.03125f);
            } else if (this.shouldRenderAsActive()) {
                this.animation_piston = this.animation_down ? Math.max(0.0f, this.animation_piston - 0.03125f) : Math.min(0.6875f, this.animation_piston + 0.03125f);
                if (this.animation_piston <= 0.0f && this.animation_down) {
                    this.animation_down = false;
                } else if ((double)this.animation_piston >= 0.6875 && !this.animation_down) {
                    this.animation_down = true;
                }
            }
        } else {
            BlockPos outputPos;
            TileEntity outputTile;
            boolean update = false;
            if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength()) {
                int n;
                Integer[] process2;
                int[] usedInvSlots = new int[8];
                for (Integer[] process2 : this.processQueue) {
                    if (!(process2 instanceof PoweredMultiblockTileEntity.MultiblockProcessInMachine)) continue;
                    int[] nArray = ((PoweredMultiblockTileEntity.MultiblockProcessInMachine)process2).getInputSlots();
                    n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        int i2;
                        int n2 = i2 = nArray[i];
                        usedInvSlots[n2] = usedInvSlots[n2] + 1;
                    }
                }
                Integer[] preferredSlots = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7};
                Arrays.sort(preferredSlots, 0, 8, Comparator.comparingInt(arg0 -> usedInvSlots[arg0]));
                process2 = preferredSlots;
                int n3 = process2.length;
                for (n = 0; n < n3; ++n) {
                    PoweredMultiblockTileEntity.MultiblockProcessInMachine<SqueezerRecipe> process3;
                    SqueezerRecipe recipe;
                    int slot = process2[n];
                    ItemStack stack = (ItemStack)this.getInventory().get(slot);
                    if (!stack.func_190926_b()) {
                        stack = stack.func_77946_l();
                        stack.func_190918_g(usedInvSlots[slot]);
                    }
                    if (stack.func_190926_b() || stack.func_190916_E() <= 0 || (recipe = this.findRecipeForInsertion(stack)) == null || !this.addProcessToQueue(process3 = new PoweredMultiblockTileEntity.MultiblockProcessInMachine<SqueezerRecipe>(recipe, slot), true)) continue;
                    this.addProcessToQueue(process3, false);
                    update = true;
                }
            }
            Direction fw = this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e();
            update |= FluidUtils.multiblockFluidOutput(this.field_145850_b, this.func_174877_v().func_177982_a(0, -1, 0).func_177967_a(fw, 2), fw, this.tanks[0], 9, 10, arg_0 -> this.inventory.get(arg_0), (arg_0, arg_1) -> this.inventory.set(arg_0, arg_1));
            if (!((ItemStack)this.inventory.get(8)).func_190926_b() && this.field_145850_b.func_82737_E() % 8L == 0L && (outputTile = Utils.getExistingTileEntity(this.field_145850_b, outputPos = this.func_174877_v())) != null) {
                ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.inventory.get(8)), (int)1);
                if ((stack = Utils.insertStackIntoInventory(this.outputCap, stack, false)).func_190926_b()) {
                    ((ItemStack)this.inventory.get(8)).func_190918_g(1);
                    if (((ItemStack)this.inventory.get(8)).func_190916_E() <= 0) {
                        this.inventory.set(8, (Object)ItemStack.field_190927_a);
                    }
                }
            }
            if (update) {
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    private DirectionalBlockPos getOutputPos() {
        Direction fw = this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e();
        return new DirectionalBlockPos(this.field_174879_c.func_177972_a(fw), fw.func_176734_d());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return this.getShape(SHAPES);
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        if (new BlockPos(2, 0, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AxisAlignedBB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875), (Object)new AxisAlignedBB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
        }
        if (new MutableBoundingBox(0, 0, 0, 1, 0, 1).func_175898_b((Vector3i)posInMultiblock)) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)});
            list.add(new AxisAlignedBB(0.0625, 0.5, 0.6875, 0.3125, 1.0, 0.9375));
            if (new BlockPos(1, 0, 1).equals((Object)posInMultiblock)) {
                list.add(new AxisAlignedBB(0.0, 0.5, 0.375, 1.125, 0.75, 0.625));
                list.add(new AxisAlignedBB(0.875, 0.5, -0.125, 1.125, 0.75, 0.375));
                list.add(new AxisAlignedBB(0.875, 0.75, -0.125, 1.125, 1.0, 0.125));
            }
            return Utils.flipBoxes(posInMultiblock.func_177952_p() == 0, posInMultiblock.func_177958_n() == 1, list);
        }
        if (new MutableBoundingBox(0, 1, 0, 1, 2, 1).func_175898_b((Vector3i)posInMultiblock)) {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(2);
            if (posInMultiblock.func_177956_o() == 1) {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0));
            }
            float minY = posInMultiblock.func_177956_o() == 1 ? 0.125f : -0.875f;
            float maxY = posInMultiblock.func_177956_o() == 1 ? 1.125f : 0.125f;
            list.add(new AxisAlignedBB(0.0, (double)minY, 0.84375, 0.15625, (double)maxY, 1.0));
            list.add(new AxisAlignedBB(0.0625, (double)minY, 0.0, 0.1875, (double)maxY, 0.84375));
            list.add(new AxisAlignedBB(0.15625, (double)minY, 0.8125, 1.0, (double)maxY, 0.9375));
            if (posInMultiblock.func_177956_o() == 2) {
                list.add(new AxisAlignedBB(0.75, 0.375, -0.25, 1.25, 0.9375, 0.25));
            }
            return Utils.flipBoxes(posInMultiblock.func_177952_p() == 0, posInMultiblock.func_177958_n() == 1, list);
        }
        if (posInMultiblock.func_177956_o() == 0 && !ImmutableSet.of((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(2, 0, 1)).contains((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (new BlockPos(2, 1, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
        }
        return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 2));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(2, 1, 2));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<SqueezerRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.outputCap, output, false)).func_190926_b()) {
            Utils.dropStackAtPos(this.field_145850_b, this.getOutputPos(), output);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<SqueezerRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 8;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 8;
    }

    @Override
    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<SqueezerRecipe> process) {
        return 0.0f;
    }

    @Override
    public int getComparatedSize() {
        return 8;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{8};
    }

    @Override
    public int[] getOutputTanks() {
        return new int[]{0};
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        SqueezerTileEntity master = (SqueezerTileEntity)this.master();
        if (master != null && new BlockPos(2, 0, 1).equals((Object)this.posInMultiblock) && (side == null || side == (this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e()))) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return true;
    }

    @Override
    public void doGraphicalUpdates() {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if ((inputOffset.equals((Object)this.posInMultiblock) || outputOffset.equals((Object)this.posInMultiblock)) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            SqueezerTileEntity master = (SqueezerTileEntity)this.master();
            if (master == null) {
                return LazyOptional.empty();
            }
            if (inputOffset.equals((Object)this.posInMultiblock)) {
                return master.insertionHandler.cast();
            }
            if (outputOffset.equals((Object)this.posInMultiblock)) {
                return master.extractionHandler.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public SqueezerRecipe findRecipeForInsertion(ItemStack inserting) {
        return SqueezerRecipe.findRecipe(inserting);
    }

    @Override
    protected SqueezerRecipe getRecipeForId(ResourceLocation id) {
        return SqueezerRecipe.recipeList.get(id);
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)((Object)this.master());
    }
}

