/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;

public class FurnaceHeaterTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHammerInteraction {
    public FluxStorage energyStorage;
    @Nullable
    EnergyHelper.IEForgeEnergyWrapper wrapper;

    public FurnaceHeaterTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.FURNACE_HEATER.get()));
        this.energyStorage = new FluxStorage(32000, Math.max(256, Math.max((Integer)IEServerConfig.MACHINES.heater_consumption.get(), (Integer)IEServerConfig.MACHINES.heater_speedupConsumption.get())));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean activeBeforeTick = this.getIsActive();
            boolean redstonePower = this.isRSPowered();
            boolean newActive = activeBeforeTick;
            if (activeBeforeTick && !redstonePower) {
                newActive = false;
            }
            if (this.energyStorage.getEnergyStored() > 3200 || activeBeforeTick) {
                for (Direction fd : DirectionUtils.VALUES) {
                    TileEntity tileEntity = Utils.getExistingTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(fd));
                    int consumed = 0;
                    if (tileEntity != null) {
                        if (tileEntity instanceof ExternalHeaterHandler.IExternalHeatable) {
                            consumed = ((ExternalHeaterHandler.IExternalHeatable)tileEntity).doHeatTick(this.energyStorage.getEnergyStored(), redstonePower);
                        } else {
                            ExternalHeaterHandler.HeatableAdapter adapter = ExternalHeaterHandler.getHeatableAdapter(tileEntity.getClass());
                            if (adapter != null) {
                                consumed = adapter.doHeatTick(tileEntity, this.energyStorage.getEnergyStored(), redstonePower);
                            }
                        }
                    }
                    if (consumed <= 0) continue;
                    this.energyStorage.extractEnergy(consumed, false);
                    newActive = true;
                }
            }
            if (newActive != activeBeforeTick) {
                this.setActive(newActive);
                this.func_70296_d();
            }
        }
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return facing == this.getFacing() ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (facing == this.getFacing()) {
            if (this.wrapper == null || this.wrapper.side != this.getFacing()) {
                this.wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, this.getFacing());
            }
            return this.wrapper;
        }
        return null;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.func_225608_bj_();
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public boolean hammerUseSide(Direction side, PlayerEntity player, Hand hand, Vector3d hitVec) {
        this.setFacing(side);
        return true;
    }
}

