/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeTileEntity;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidPumpTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IConfigurableSides,
IFluidPipe,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IBlockOverlayText {
    public Map<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);
    public FluidTank tank;
    public FluxStorage energyStorage;
    public boolean placeCobble;
    boolean checkingArea;
    Fluid searchFluid;
    ArrayList<BlockPos> openList;
    ArrayList<BlockPos> closedList;
    ArrayList<BlockPos> checked;
    private Map<Direction, CapabilityReference<IFluidHandler>> neighborFluids;
    private Map<Direction, LazyOptional<IFluidHandler>> sidedFluidHandler;
    EnergyHelper.IEForgeEnergyWrapper wrapper;

    public FluidPumpTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.FLUID_PUMP.get()));
        for (Direction d : DirectionUtils.VALUES) {
            if (d == Direction.DOWN) {
                this.sideConfig.put(d, IEEnums.IOSideConfig.INPUT);
                continue;
            }
            this.sideConfig.put(d, IEEnums.IOSideConfig.NONE);
        }
        this.tank = new FluidTank(4000);
        this.energyStorage = new FluxStorage(8000);
        this.placeCobble = true;
        this.checkingArea = false;
        this.searchFluid = null;
        this.openList = new ArrayList();
        this.closedList = new ArrayList();
        this.checked = new ArrayList();
        this.neighborFluids = new EnumMap<Direction, CapabilityReference<IFluidHandler>>(Direction.class);
        for (Direction neighbor : DirectionUtils.VALUES) {
            this.neighborFluids.put(neighbor, CapabilityReference.forNeighbor((TileEntity)this, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, neighbor));
        }
        this.sidedFluidHandler = new EnumMap<Direction, LazyOptional<IFluidHandler>>(Direction.class);
        this.wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, Direction.UP);
    }

    public void func_73660_a() {
        TileEntity above;
        this.checkForNeedlessTicking();
        if (this.isDummy() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tank.getFluidAmount() > 0) {
            int i = this.outputFluid(this.tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
            this.tank.drain(i, IFluidHandler.FluidAction.EXECUTE);
        }
        int consumption = (Integer)IEServerConfig.MACHINES.pump_consumption.get();
        boolean hasRSSignal = this.isRSPowered();
        if (!hasRSSignal && (above = this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a())) instanceof FluidPumpTileEntity) {
            hasRSSignal = ((FluidPumpTileEntity)above).isRSPowered();
        }
        if (this.isRSPowered()) {
            for (TileEntity f : Direction.values()) {
                if (this.sideConfig.get(f) != IEEnums.IOSideConfig.INPUT) continue;
                CapabilityReference<IFluidHandler> input = this.neighborFluids.get(f);
                if (input.isPresent()) {
                    IFluidHandler handler = input.get();
                    int drainAmount = IFluidPipe.getTransferableAmount(this.canOutputPressurized(false));
                    FluidStack drain = handler.drain(500, IFluidHandler.FluidAction.SIMULATE);
                    if (drain.isEmpty()) continue;
                    int out = this.outputFluid(drain, IFluidHandler.FluidAction.EXECUTE);
                    handler.drain(out, IFluidHandler.FluidAction.EXECUTE);
                    continue;
                }
                if (this.field_145850_b.func_82737_E() % 20L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x13) || !this.field_145850_b.func_204610_c(this.func_174877_v().func_177972_a((Direction)f)).func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a) || !((Boolean)IEServerConfig.MACHINES.pump_infiniteWater.get()).booleanValue() || this.tank.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.SIMULATE) != 1000 || this.energyStorage.extractEnergy(consumption, true) < consumption) continue;
                int connectedSources = 0;
                for (Direction f2 : DirectionUtils.BY_HORIZONTAL_INDEX) {
                    FluidState waterState = this.field_145850_b.func_204610_c(this.func_174877_v().func_177972_a((Direction)f).func_177972_a(f2));
                    if (!waterState.func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a) || !waterState.func_206889_d()) continue;
                    ++connectedSources;
                }
                if (connectedSources <= true) continue;
                this.energyStorage.extractEnergy(consumption, false);
                this.tank.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
            }
            if (this.field_145850_b.func_82737_E() % 40L == (long)(((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) % 40 + 40) % 40)) {
                if (this.closedList.isEmpty()) {
                    this.prepareAreaCheck();
                } else {
                    int target = this.closedList.size() - 1;
                    BlockPos pos = this.closedList.get(target);
                    FluidStack fs = Utils.drainFluidBlock(this.field_145850_b, pos, IFluidHandler.FluidAction.SIMULATE);
                    if (fs == null) {
                        this.closedList.remove(target);
                    } else if (this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE) == fs.getAmount() && this.energyStorage.extractEnergy(consumption, true) >= consumption) {
                        this.energyStorage.extractEnergy(consumption, false);
                        fs = Utils.drainFluidBlock(this.field_145850_b, pos, IFluidHandler.FluidAction.EXECUTE);
                        if (((Boolean)IEServerConfig.MACHINES.pump_placeCobble.get()).booleanValue() && this.placeCobble) {
                            this.field_145850_b.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
                        }
                        this.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                        this.closedList.remove(target);
                    }
                }
            }
        }
        if (this.checkingArea) {
            this.checkAreaTick();
        }
    }

    public void prepareAreaCheck() {
        this.openList.clear();
        this.closedList.clear();
        this.checked.clear();
        for (Direction f : Direction.values()) {
            if (this.sideConfig.get(f) != IEEnums.IOSideConfig.INPUT) continue;
            this.openList.add(this.func_174877_v().func_177972_a(f));
            this.checkingArea = true;
        }
    }

    public void checkAreaTick() {
        boolean infiniteWater = (Boolean)IEServerConfig.MACHINES.pump_infiniteWater.get();
        BlockPos next = null;
        int closedListMax = 2048;
        int timeout = 0;
        while (timeout < 64 && this.closedList.size() < 2048 && !this.openList.isEmpty()) {
            ++timeout;
            next = this.openList.get(0);
            if (!this.checked.contains(next)) {
                Fluid fluid = Utils.getRelatedFluid(this.getWorldNonnull(), next);
                if (!(fluid == Fluids.field_204541_a || fluid == Fluids.field_204546_a && infiniteWater || this.searchFluid != null && fluid != this.searchFluid)) {
                    if (this.searchFluid == null) {
                        this.searchFluid = fluid;
                    }
                    if (!Utils.drainFluidBlock(this.field_145850_b, next, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                        this.closedList.add(next);
                    }
                    for (Direction f : Direction.values()) {
                        BlockPos pos2 = next.func_177972_a(f);
                        fluid = Utils.getRelatedFluid(this.field_145850_b, pos2);
                        if (fluid == Fluids.field_204541_a || this.checked.contains(pos2) || this.closedList.contains(pos2) || this.openList.contains(pos2) || fluid == Fluids.field_204546_a && infiniteWater || this.searchFluid != null && fluid != this.searchFluid) continue;
                        this.openList.add(pos2);
                    }
                }
                this.checked.add(next);
            }
            this.openList.remove(0);
        }
        if (this.closedList.size() >= 2048 || this.openList.isEmpty()) {
            this.checkingArea = false;
        }
    }

    public int outputFluid(FluidStack fs, IFluidHandler.FluidAction action) {
        if (fs.isEmpty()) {
            return 0;
        }
        int canAccept = fs.getAmount();
        if (canAccept <= 0) {
            return 0;
        }
        int accelPower = (Integer)IEServerConfig.MACHINES.pump_consumption_accelerate.get();
        int fluidForSort = canAccept;
        int sum = 0;
        HashMap<FluidPipeTileEntity.DirectionalFluidOutput, Integer> sorting = new HashMap<FluidPipeTileEntity.DirectionalFluidOutput, Integer>();
        for (Direction f : Direction.values()) {
            int temp;
            CapabilityReference<IFluidHandler> output;
            if (this.sideConfig.get(f) != IEEnums.IOSideConfig.OUTPUT || !(output = this.neighborFluids.get(f)).isPresent()) continue;
            TileEntity tile = this.getWorldNonnull().func_175625_s(this.field_174879_c.func_177972_a(f));
            IFluidHandler handler = output.get();
            FluidStack insertResource = Utils.copyFluidStackWithAmount(fs, fs.getAmount(), true);
            if (tile instanceof FluidPipeTileEntity && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                insertResource.getOrCreateTag().func_74757_a("pressurized", true);
            }
            if ((temp = handler.fill(insertResource, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            sorting.put(new FluidPipeTileEntity.DirectionalFluidOutput(handler, tile, f), temp);
            sum += temp;
        }
        if (sum > 0) {
            int f = 0;
            int i = 0;
            for (FluidPipeTileEntity.DirectionalFluidOutput output : sorting.keySet()) {
                float prio = (float)((Integer)sorting.get(output)).intValue() / (float)sum;
                int amount = (int)((float)fluidForSort * prio);
                if (i++ == sorting.size() - 1) {
                    amount = canAccept;
                }
                FluidStack insertResource = Utils.copyFluidStackWithAmount(fs, amount, true);
                if (output.containingTile instanceof FluidPipeTileEntity && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                    this.energyStorage.extractEnergy(accelPower, false);
                    insertResource.getOrCreateTag().func_74757_a("pressurized", true);
                }
                int r = output.output.fill(insertResource, action);
                f += r;
                if ((canAccept -= r) > 0) continue;
                break;
            }
            return f;
        }
        return 0;
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        int[] sideConfigArray = nbt.func_74759_k("sideConfig");
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put(d, IEEnums.IOSideConfig.VALUES[sideConfigArray[d.ordinal()]]);
        }
        if (nbt.func_150297_b("placeCobble", 1)) {
            this.placeCobble = nbt.func_74767_n("placeCobble");
        }
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.energyStorage.readFromNBT(nbt);
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        int[] sideConfigArray = new int[6];
        for (Direction d : DirectionUtils.VALUES) {
            sideConfigArray[d.ordinal()] = this.sideConfig.get(d).ordinal();
        }
        nbt.func_74783_a("sideConfig", sideConfigArray);
        nbt.func_74757_a("placeCobble", this.placeCobble);
        nbt.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.get(side);
    }

    @Override
    public boolean toggleSide(Direction side, PlayerEntity p) {
        if (side != Direction.UP && !this.isDummy()) {
            this.sideConfig.put(side, IEEnums.IOSideConfig.next(this.sideConfig.get(side)));
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            this.getWorldNonnull().func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, 0);
            return true;
        }
        if (p.func_225608_bj_()) {
            TileEntity tmp;
            FluidPumpTileEntity master = this;
            if (this.isDummy() && (tmp = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof FluidPumpTileEntity) {
                master = (FluidPumpTileEntity)tmp;
            }
            master.placeCobble = !master.placeCobble;
            ChatUtils.sendServerNoSpamMessages(p, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.pump.placeCobble." + master.placeCobble)});
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && !this.isDummy()) {
            if (!this.sidedFluidHandler.containsKey(facing)) {
                this.sidedFluidHandler.put(facing, this.registerConstantCap(new SidedFluidHandler(this, facing)));
            }
            return this.sidedFluidHandler.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ITextComponent[] getOverlayText(PlayerEntity player, RayTraceResult mop, boolean hammer) {
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && !this.isDummy() && mop instanceof BlockRayTraceResult) {
            BlockRayTraceResult brtr = (BlockRayTraceResult)mop;
            IEEnums.IOSideConfig i = this.sideConfig.get(brtr.func_216354_b());
            IEEnums.IOSideConfig j = this.sideConfig.get(brtr.func_216354_b().func_176734_d());
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectFluid.", i, j);
        }
        return null;
    }

    @Override
    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }

    public void setDummy(boolean dummy) {
        BlockState old = this.func_195044_w();
        BlockState newState = (BlockState)old.func_206870_a((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(dummy));
        this.setState(newState);
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.isDummy() && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -1, 0))) instanceof FluidPumpTileEntity) {
            return ((FluidPumpTileEntity)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return this.isDummy() && facing == Direction.UP ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (!this.isDummy() && facing == Direction.UP) {
            return null;
        }
        return this.wrapper;
    }

    @Override
    public boolean isDummy() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)IEProperties.MULTIBLOCKSLAVE);
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.func_174877_v().func_177977_b();
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockItemUseContext ctx, BlockState state) {
        BlockPos dummyPos = this.field_174879_c.func_177984_a();
        this.getWorldNonnull().func_175656_a(dummyPos, IEBaseBlock.applyLocationalWaterlogging(state, this.getWorldNonnull(), dummyPos));
        TileEntity tile = this.getWorldNonnull().func_175625_s(dummyPos);
        if (tile instanceof FluidPumpTileEntity) {
            ((FluidPumpTileEntity)tile).setDummy(true);
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        for (int i = 0; i <= 1; ++i) {
            if (!Utils.isBlockAt(this.field_145850_b, this.func_174877_v().func_177982_a(0, this.isDummy() ? -1 : 0, 0).func_177982_a(0, i, 0), IEBlocks.MetalDevices.fluidPump)) continue;
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(0, this.isDummy() ? -1 : 0, 0).func_177982_a(0, i, 0), false);
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        if (!this.isDummy()) {
            return VoxelShapes.func_197868_b();
        }
        return VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    }

    @Override
    public boolean canOutputPressurized(boolean consumePower) {
        int accelPower = (Integer)IEServerConfig.MACHINES.pump_consumption_accelerate.get();
        if (this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
            if (consumePower) {
                this.energyStorage.extractEnergy(accelPower, false);
            }
            return true;
        }
        return false;
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        FluidPumpTileEntity pump;
        Direction facing;

        SidedFluidHandler(FluidPumpTileEntity pump, Direction facing) {
            this.pump = pump;
            this.facing = facing;
        }

        public int getTanks() {
            return this.pump.tank.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.pump.tank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.pump.tank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            if (this.pump.sideConfig.get(this.facing) != IEEnums.IOSideConfig.INPUT) {
                return false;
            }
            return this.pump.tank.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || this.pump.sideConfig.get(this.facing) != IEEnums.IOSideConfig.INPUT) {
                return 0;
            }
            return this.pump.tank.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.drain(resource.getAmount(), action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.pump.sideConfig.get(this.facing) != IEEnums.IOSideConfig.OUTPUT) {
                return FluidStack.EMPTY;
            }
            return this.pump.tank.drain(maxDrain, action);
        }
    }
}

