/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConveyorBeltTileEntity
extends IEBaseTileEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IPlayerInteraction,
ConveyorHandler.IConveyorTile,
IEBlockInterfaces.IPropertyPassthrough,
ITickableTileEntity {
    private final ConveyorHandler.IConveyorBelt conveyorBeltSubtype;
    private static final VoxelShape COLISIONBB = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    private LazyOptional<IItemHandler> insertionCap = this.registerCap(() -> new ConveyorInventoryHandler(this));

    public ConveyorBeltTileEntity(ResourceLocation typeName) {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)Preconditions.checkNotNull(ConveyorHandler.getTEType(typeName), (Object)("Not TE type for " + typeName))));
        this.conveyorBeltSubtype = ConveyorHandler.getConveyor(typeName, this);
    }

    @Override
    @Nullable
    public ConveyorHandler.IConveyorBelt getConveyorSubtype() {
        return this.conveyorBeltSubtype;
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (this.conveyorBeltSubtype != null) {
            this.conveyorBeltSubtype.onEntityCollision(entity);
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        if (nbt.func_150297_b("conveyorBeltSubtypeNBT", 10)) {
            this.conveyorBeltSubtype.readConveyorNBT(nbt.func_74775_l("conveyorBeltSubtypeNBT"));
        }
        if (descPacket && this.field_145850_b != null) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        if (this.conveyorBeltSubtype != null) {
            nbt.func_218657_a("conveyorBeltSubtypeNBT", (INBT)this.conveyorBeltSubtype.writeConveyorNBT());
        }
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return ConveyorBlock.FACING;
    }

    @Override
    public Direction getFacing() {
        return IEBlockInterfaces.IStateBasedDirectional.super.getFacing();
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL_QUADRANT;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return !entity.func_225608_bj_();
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public void afterRotation(Direction oldDir, Direction newDir) {
        if (this.conveyorBeltSubtype != null) {
            this.conveyorBeltSubtype.afterRotation(oldDir, newDir);
        }
    }

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking(this, te -> te.conveyorBeltSubtype != null && !te.conveyorBeltSubtype.isTicking());
        if (this.conveyorBeltSubtype != null) {
            this.conveyorBeltSubtype.onUpdate();
        }
    }

    @Override
    public boolean hammerUseSide(Direction side, PlayerEntity player, Hand hand, Vector3d hitVec) {
        if (player.func_225608_bj_() && this.conveyorBeltSubtype != null && this.conveyorBeltSubtype.changeConveyorDirection()) {
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
                this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        DyeColor dye;
        boolean update;
        if (this.conveyorBeltSubtype != null && (update = this.conveyorBeltSubtype.canBeDyed() && Utils.isDye(heldItem) ? (dye = Utils.getDye(heldItem)) != null && this.conveyorBeltSubtype.setDyeColour(dye) : this.conveyorBeltSubtype.playerInteraction(player, hand, heldItem, hitX, hitY, hitZ, side))) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, 0);
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape getCollisionShape(ISelectionContext ctx) {
        if (this.conveyorBeltSubtype != null) {
            return this.conveyorBeltSubtype.getCollisionShape();
        }
        return COLISIONBB;
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable ISelectionContext ctx) {
        if (this.conveyorBeltSubtype != null) {
            return this.conveyorBeltSubtype.getSelectionShape();
        }
        return COLISIONBB;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.insertionCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean isRSPowered() {
        return super.isRSPowered();
    }

    public static void registerConveyorTEs(RegistryEvent.Register<TileEntityType<?>> evt) {
        for (ResourceLocation rl : ConveyorHandler.classRegistry.keySet()) {
            TileEntityType te = new TileEntityType(() -> new ConveyorBeltTileEntity(rl), (Set)ImmutableSet.of((Object)ConveyorHandler.conveyorBlocks.get(rl)), null);
            te.setRegistryName(ConveyorHandler.getRegistryNameFor(rl));
            ConveyorHandler.tileEntities.put(rl, (TileEntityType<? extends TileEntity>)te);
            evt.getRegistry().register((IForgeRegistryEntry)te);
        }
    }

    public static class ConveyorInventoryHandler
    implements IItemHandlerModifiable {
        ConveyorBeltTileEntity conveyor;

        public ConveyorInventoryHandler(ConveyorBeltTileEntity conveyor) {
            this.conveyor = conveyor;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.conveyor.getConveyorSubtype().isBlocked()) {
                return stack;
            }
            if (!simulate) {
                ItemEntity entity = new ItemEntity(this.conveyor.getWorldNonnull(), (double)this.conveyor.func_174877_v().func_177958_n() + 0.5, (double)this.conveyor.func_174877_v().func_177956_o() + 0.1875, (double)this.conveyor.func_174877_v().func_177952_p() + 0.5, stack.func_77946_l());
                entity.func_213317_d(Vector3d.field_186680_a);
                this.conveyor.getWorldNonnull().func_217376_c((Entity)entity);
                if (this.conveyor.conveyorBeltSubtype != null) {
                    this.conveyor.conveyorBeltSubtype.onItemDeployed(entity);
                }
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

