/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.cloth.StripCurtainBlock;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class StripCurtainTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IRedstoneOutput,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.IAdvancedDirectionalTile,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IColouredTile,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.ISelectionBounds {
    public int colour = 0xFFFFFF;
    private int redstoneSignal = 0;
    private boolean strongSignal = false;
    private static final AxisAlignedBB[] bounds = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 0.0625), new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 0.1875, 1.0), new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.8125, 0.46875, 1.0, 1.0, 0.53125), new AxisAlignedBB(0.46875, 0.8125, 0.0, 0.53125, 1.0, 1.0)};
    private static final CachedVoxelShapes<Pair<Boolean, Direction>> SHAPES = new CachedVoxelShapes<Pair>(StripCurtainTileEntity::getShape);

    public StripCurtainTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.STRIP_CURTAIN.get()));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 4L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 3)) {
            AxisAlignedBB aabb = bounds[this.isCeilingAttached() ? (this.getFacing().func_176740_k() == Direction.Axis.Z ? 4 : 5) : (this.getFacing().ordinal() - 2) % 4];
            aabb = new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b - 0.8125, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_186670_a(this.func_174877_v());
            List entities = this.field_145850_b.func_217357_a(Entity.class, aabb);
            if (!this.isCeilingAttached() && !entities.isEmpty() && this.redstoneSignal == 0) {
                this.redstoneSignal = 15;
                this.sendRSUpdates();
            }
            if (entities.isEmpty() && this.redstoneSignal != 0) {
                this.redstoneSignal = 0;
                this.sendRSUpdates();
            }
        }
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (this.isCeilingAttached() && entity.func_70089_S() && this.redstoneSignal == 0) {
            this.redstoneSignal = 15;
            this.sendRSUpdates();
        }
    }

    private void sendRSUpdates() {
        this.func_70296_d();
        this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        this.field_145850_b.func_195593_d(this.func_174877_v().func_177972_a(this.getStrongSignalSide()), this.func_195044_w().func_177230_c());
    }

    private Direction getStrongSignalSide() {
        if (this.isCeilingAttached()) {
            return Direction.UP;
        }
        return this.getFacing();
    }

    private AxisAlignedBB getEntityCollectionBox() {
        AxisAlignedBB aabb = bounds[this.isCeilingAttached() ? (this.getFacing().func_176740_k() == Direction.Axis.Z ? 4 : 5) : (this.getFacing().ordinal() - 2) % 4];
        return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b - 0.8125, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_186670_a(this.func_174877_v());
    }

    @Override
    public int getStrongRSOutput(@Nonnull Direction side) {
        if (!this.strongSignal || side != this.getStrongSignalSide().func_176734_d()) {
            return 0;
        }
        return this.getWeakRSOutput(side);
    }

    @Override
    public int getWeakRSOutput(@Nonnull Direction side) {
        if (side == Direction.DOWN) {
            return 0;
        }
        return this.redstoneSignal;
    }

    @Override
    public boolean canConnectRedstone(@Nonnull Direction side) {
        return false;
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.colour = nbt.func_74762_e("colour");
        this.strongSignal = nbt.func_74767_n("strongSignal");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74768_a("colour", this.colour);
        nbt.func_74757_a("strongSignal", this.strongSignal);
    }

    @Override
    @Nonnull
    public VoxelShape getSelectionShape(@Nullable ISelectionContext ctx) {
        AxisAlignedBB aabb = bounds[this.isCeilingAttached() ? (this.getFacing().func_176740_k() == Direction.Axis.Z ? 4 : 5) : (this.getFacing().ordinal() - 2) % 4];
        return VoxelShapes.func_197873_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c, (double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f);
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape(ISelectionContext ctx) {
        return SHAPES.get((Pair<Boolean, Direction>)Pair.of((Object)this.isCeilingAttached(), (Object)this.getFacing()));
    }

    private static List<AxisAlignedBB> getShape(Pair<Boolean, Direction> key) {
        int index = ((Boolean)key.getLeft()).booleanValue() ? (((Direction)key.getRight()).func_176740_k() == Direction.Axis.Z ? 4 : 5) : (((Direction)key.getRight()).ordinal() - 2) % 4;
        return Lists.newArrayList((Object[])new AxisAlignedBB[]{bounds[index]});
    }

    @Override
    @Nonnull
    public Property<Direction> getFacingProperty() {
        return StripCurtainBlock.FACING;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public void onDirectionalPlacement(Direction side, float hitX, float hitY, float hitZ, LivingEntity placer) {
        if (side == Direction.DOWN) {
            this.setCeilingAttached(true);
        } else {
            this.setCeilingAttached(false);
        }
    }

    @Override
    public int getRenderColour(int tintIndex) {
        if (tintIndex == 1) {
            return this.colour;
        }
        return 0xFFFFFF;
    }

    @Override
    public List<ItemStack> getTileDrops(LootContext context) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_195044_w().func_177230_c(), 1);
        if (this.colour != 0xFFFFFF) {
            ItemNBTHelper.putInt(stack, "colour", this.colour);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "colour")) {
            this.colour = ItemNBTHelper.getInt(stack, "colour");
        }
    }

    @Override
    public ActionResultType screwdriverUseSide(Direction side, PlayerEntity player, Hand hand, Vector3d hitVec) {
        if (!this.field_145850_b.field_72995_K) {
            this.strongSignal = !this.strongSignal;
            ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.rsControl.strongSignal." + this.strongSignal)});
            this.sendRSUpdates();
        }
        return ActionResultType.SUCCESS;
    }

    public boolean isCeilingAttached() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)StripCurtainBlock.CEILING_ATTACHED);
    }

    public void setCeilingAttached(boolean ceilingAttached) {
        BlockState newState = (BlockState)this.func_195044_w().func_206870_a((Property)StripCurtainBlock.CEILING_ATTACHED, (Comparable)Boolean.valueOf(ceilingAttached));
        this.getWorldNonnull().func_175656_a(this.field_174879_c, newState);
    }
}

