/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.SmartLightingQuad;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class ModelUtils {
    private static final float[] FOUR_ONES = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public static Set<BakedQuad> createBakedBox(Vector3d from, Vector3d to, Matrix4 matrix, Direction facing, Function<Direction, TextureAtlasSprite> textureGetter, float[] colour) {
        return ModelUtils.createBakedBox(from, to, matrix, facing, vertices -> vertices, textureGetter, colour);
    }

    @Nonnull
    public static Set<BakedQuad> createBakedBox(Vector3d from, Vector3d to, Matrix4 matrixIn, Direction facing, Function<Vector3d[], Vector3d[]> vertexTransformer, Function<Direction, TextureAtlasSprite> textureGetter, float[] colour) {
        Vector3d v2;
        int i;
        TransformationMatrix matrix = matrixIn.toTransformationMatrix();
        HashSet<BakedQuad> quads = new HashSet<BakedQuad>();
        if (vertexTransformer == null) {
            vertexTransformer = v -> v;
        }
        Vector3d[] vertices = new Vector3d[]{new Vector3d(from.field_72450_a, from.field_72448_b, from.field_72449_c), new Vector3d(from.field_72450_a, from.field_72448_b, to.field_72449_c), new Vector3d(to.field_72450_a, from.field_72448_b, to.field_72449_c), new Vector3d(to.field_72450_a, from.field_72448_b, from.field_72449_c)};
        TextureAtlasSprite sprite = textureGetter.apply(Direction.DOWN);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.DOWN, facing), sprite, new double[]{from.field_72450_a * 16.0, 16.0 - from.field_72449_c * 16.0, to.field_72450_a * 16.0, 16.0 - to.field_72449_c * 16.0}, colour, true));
        }
        for (i = 0; i < vertices.length; ++i) {
            v2 = vertices[i];
            vertices[i] = new Vector3d(v2.field_72450_a, to.field_72448_b, v2.field_72449_c);
        }
        sprite = textureGetter.apply(Direction.UP);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.UP, facing), sprite, new double[]{from.field_72450_a * 16.0, from.field_72449_c * 16.0, to.field_72450_a * 16.0, to.field_72449_c * 16.0}, colour, false));
        }
        vertices = new Vector3d[]{new Vector3d(to.field_72450_a, to.field_72448_b, from.field_72449_c), new Vector3d(to.field_72450_a, from.field_72448_b, from.field_72449_c), new Vector3d(from.field_72450_a, from.field_72448_b, from.field_72449_c), new Vector3d(from.field_72450_a, to.field_72448_b, from.field_72449_c)};
        sprite = textureGetter.apply(Direction.NORTH);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.NORTH, facing), sprite, new double[]{from.field_72450_a * 16.0, 16.0 - to.field_72448_b * 16.0, to.field_72450_a * 16.0, 16.0 - from.field_72448_b * 16.0}, colour, false));
        }
        for (i = 0; i < vertices.length; ++i) {
            v2 = vertices[i];
            vertices[i] = new Vector3d(v2.field_72450_a, v2.field_72448_b, to.field_72449_c);
        }
        sprite = textureGetter.apply(Direction.SOUTH);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.SOUTH, facing), sprite, new double[]{to.field_72450_a * 16.0, 16.0 - to.field_72448_b * 16.0, from.field_72450_a * 16.0, 16.0 - from.field_72448_b * 16.0}, colour, true));
        }
        vertices = new Vector3d[]{new Vector3d(from.field_72450_a, to.field_72448_b, to.field_72449_c), new Vector3d(from.field_72450_a, from.field_72448_b, to.field_72449_c), new Vector3d(from.field_72450_a, from.field_72448_b, from.field_72449_c), new Vector3d(from.field_72450_a, to.field_72448_b, from.field_72449_c)};
        sprite = textureGetter.apply(Direction.WEST);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.WEST, facing), sprite, new double[]{to.field_72449_c * 16.0, 16.0 - to.field_72448_b * 16.0, from.field_72449_c * 16.0, 16.0 - from.field_72448_b * 16.0}, colour, true));
        }
        for (i = 0; i < vertices.length; ++i) {
            v2 = vertices[i];
            vertices[i] = new Vector3d(to.field_72450_a, v2.field_72448_b, v2.field_72449_c);
        }
        sprite = textureGetter.apply(Direction.EAST);
        if (sprite != null) {
            quads.add(ModelUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.EAST, facing), sprite, new double[]{16.0 - to.field_72449_c * 16.0, 16.0 - to.field_72448_b * 16.0, 16.0 - from.field_72449_c * 16.0, 16.0 - from.field_72448_b * 16.0}, colour, false));
        }
        return quads;
    }

    public static BakedQuad createSmartLightingBakedQuad(VertexFormat format, Vector3d[] vertices, Direction facing, TextureAtlasSprite sprite, float[] colour, boolean invert, BlockPos base) {
        return ModelUtils.createBakedQuad(format, vertices, facing, sprite, new double[]{0.0, 0.0, 16.0, 16.0}, colour, invert, FOUR_ONES, true, base);
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vector3d[] vertices, Direction facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert) {
        return ModelUtils.createBakedQuad(format, vertices, facing, sprite, uvs, colour, invert, FOUR_ONES);
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vector3d[] vertices, Direction facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert, float[] alpha) {
        return ModelUtils.createBakedQuad(format, vertices, facing, sprite, uvs, colour, invert, alpha, false, null);
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vector3d[] vertices, Direction facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert, float[] alpha, boolean smartLighting, BlockPos basePos) {
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(facing);
        builder.setApplyDiffuseLighting(true);
        Vector3i normalInt = facing.func_176730_m();
        Vector3d faceNormal = new Vector3d((double)normalInt.func_177958_n(), (double)normalInt.func_177956_o(), (double)normalInt.func_177952_p());
        int vId = invert ? 3 : 0;
        int u = vId > 1 ? 2 : 0;
        ModelUtils.putVertexData(format, builder, vertices[vId], faceNormal, uvs[u], uvs[1], sprite, colour, alpha[vId]);
        vId = invert ? 2 : 1;
        u = vId > 1 ? 2 : 0;
        ModelUtils.putVertexData(format, builder, vertices[vId], faceNormal, uvs[u], uvs[3], sprite, colour, alpha[vId]);
        vId = invert ? 1 : 2;
        u = vId > 1 ? 2 : 0;
        ModelUtils.putVertexData(format, builder, vertices[vId], faceNormal, uvs[u], uvs[3], sprite, colour, alpha[vId]);
        vId = invert ? 0 : 3;
        u = vId > 1 ? 2 : 0;
        ModelUtils.putVertexData(format, builder, vertices[vId], faceNormal, uvs[u], uvs[1], sprite, colour, alpha[vId]);
        BakedQuad tmp = builder.build();
        return smartLighting ? new SmartLightingQuad(tmp.func_178209_a(), -1, facing, sprite, basePos) : tmp;
    }

    public static void putVertexData(VertexFormat format, BakedQuadBuilder builder, Vector3d pos, Vector3d faceNormal, double u, double v, TextureAtlasSprite sprite, float[] colour, float alpha) {
        block6: for (int e = 0; e < format.func_227894_c_().size(); ++e) {
            switch (((VertexFormatElement)format.func_227894_c_().get(e)).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c});
                    continue block6;
                }
                case COLOR: {
                    float d = 1.0f;
                    builder.put(e, new float[]{d * colour[0], d * colour[1], d * colour[2], 1.0f * colour[3] * alpha});
                    continue block6;
                }
                case UV: {
                    if (((VertexFormatElement)format.func_227894_c_().get(e)).func_177367_b() == VertexFormatElement.Type.FLOAT) {
                        if (sprite == null) {
                            sprite = ModelUtils.getMissingSprite();
                        }
                        builder.put(e, new float[]{sprite.func_94214_a(u), sprite.func_94207_b(v)});
                        continue block6;
                    }
                    builder.put(e, new float[]{0.0f, 0.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)faceNormal.func_82615_a(), (float)faceNormal.func_82617_b(), (float)faceNormal.func_82616_c()});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private static TextureAtlasSprite getMissingSprite() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(MissingTextureSprite.func_195675_b());
    }

    public static ResourceLocation getSideTexture(@Nonnull ItemStack stack, Direction side) {
        IBakedModel model = ClientUtils.mc().func_175599_af().func_184393_a(stack, null, null);
        return ModelUtils.getSideTexture(model, side, null);
    }

    public static ResourceLocation getSideTexture(@Nonnull BlockState state, Direction side) {
        IBakedModel model = ClientUtils.mc().func_175602_ab().func_184389_a(state);
        return ModelUtils.getSideTexture(model, side, state);
    }

    public static ResourceLocation getSideTexture(@Nonnull IBakedModel model, Direction side, @Nullable BlockState state) {
        List quads = model.getQuads(state, side, Utils.RAND, (IModelData)EmptyModelData.INSTANCE);
        if (quads.isEmpty()) {
            quads = model.getQuads(state, null, Utils.RAND, (IModelData)EmptyModelData.INSTANCE);
        }
        if (quads.isEmpty()) {
            return null;
        }
        return ((BakedQuad)quads.get(0)).func_187508_a().func_195668_m();
    }
}

