/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class SafeChunkUtils {
    private static final Map<IWorld, Set<ChunkPos>> unloadingChunks = new WeakHashMap<IWorld, Set<ChunkPos>>();

    public static Chunk getSafeChunk(IWorld w, BlockPos pos) {
        AbstractChunkProvider provider = w.func_72863_F();
        ChunkPos chunkPos = new ChunkPos(pos);
        if (unloadingChunks.getOrDefault(w, (Set<ChunkPos>)ImmutableSet.of()).contains(chunkPos)) {
            return null;
        }
        if (provider.func_222866_a(pos)) {
            return provider.func_217205_a(chunkPos.field_77276_a, chunkPos.field_77275_b, false);
        }
        return null;
    }

    public static boolean isChunkSafe(IWorld w, BlockPos pos) {
        return SafeChunkUtils.getSafeChunk(w, pos) != null;
    }

    public static TileEntity getSafeTE(IWorld w, BlockPos pos) {
        Chunk c = SafeChunkUtils.getSafeChunk(w, pos);
        if (c == null) {
            return null;
        }
        return c.func_175625_s(pos);
    }

    @Nonnull
    public static BlockState getBlockState(IWorld w, BlockPos pos) {
        Chunk c = SafeChunkUtils.getSafeChunk(w, pos);
        if (c == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return c.func_180495_p(pos);
    }

    public static int getRedstonePower(World w, BlockPos pos, Direction d) {
        if (!SafeChunkUtils.isChunkSafe((IWorld)w, pos)) {
            return 0;
        }
        return w.func_175651_c(pos, d);
    }

    public static int getRedstonePowerFromNeighbors(World w, BlockPos pos) {
        Direction d;
        int atNeighbor;
        int ret = 0;
        Direction[] directionArray = DirectionUtils.VALUES;
        int n = directionArray.length;
        for (int i = 0; i < n && (ret = Math.max(ret, atNeighbor = SafeChunkUtils.getRedstonePower(w, pos.func_177972_a(d = directionArray[i]), d))) < 15; ++i) {
        }
        return ret;
    }

    public static void onChunkUnload(ChunkEvent.Unload ev) {
        unloadingChunks.computeIfAbsent(ev.getWorld(), w -> new HashSet()).add(ev.getChunk().func_76632_l());
    }

    public static void onTick(TickEvent.WorldTickEvent ev) {
        if (ev.phase == TickEvent.Phase.START) {
            unloadingChunks.remove(ev.world);
        }
    }
}

