/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.excavator;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraftforge.common.util.Lazy;

public class MineralVein {
    private final ColumnPos pos;
    private final ResourceLocation mineralName;
    private final Lazy<MineralMix> mineral;
    private final int radius;
    private int depletion;

    public MineralVein(ColumnPos pos, ResourceLocation mineral, int radius) {
        this.pos = pos;
        this.mineralName = mineral;
        this.mineral = Lazy.of(() -> MineralMix.mineralList.get(this.mineralName));
        this.radius = radius;
    }

    public ColumnPos getPos() {
        return this.pos;
    }

    @Nullable
    public MineralMix getMineral() {
        return (MineralMix)this.mineral.get();
    }

    public int getRadius() {
        return this.radius;
    }

    public double getFailChance(BlockPos pos) {
        double dX = pos.func_177958_n() - this.pos.field_219439_a;
        double dZ = pos.func_177952_p() - this.pos.field_219440_b;
        double d = (dX * dX + dZ * dZ) / (double)(this.radius * this.radius);
        return d * d * (-2.0 * d + 3.0);
    }

    public int getDepletion() {
        return this.depletion;
    }

    public void setDepletion(int depletion) {
        this.depletion = depletion;
    }

    public void deplete() {
        if (!this.isDepleted()) {
            ++this.depletion;
            ExcavatorHandler.MARK_SAVE_DATA_DIRTY.getValue().run();
        }
    }

    public boolean isDepleted() {
        return ExcavatorHandler.mineralVeinYield > 0 && this.getDepletion() >= ExcavatorHandler.mineralVeinYield;
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("x", this.pos.field_219439_a);
        tag.func_74768_a("z", this.pos.field_219440_b);
        tag.func_74778_a("mineral", this.mineralName.toString());
        tag.func_74768_a("radius", this.radius);
        tag.func_74768_a("depletion", this.depletion);
        return tag;
    }

    @Nullable
    public static MineralVein readFromNBT(CompoundNBT tag) {
        try {
            ColumnPos pos = new ColumnPos(tag.func_74762_e("x"), tag.func_74762_e("z"));
            ResourceLocation id = new ResourceLocation(tag.func_74779_i("mineral"));
            int radius = tag.func_74762_e("radius");
            MineralVein info = new MineralVein(pos, id, radius);
            info.depletion = tag.func_74762_e("depletion");
            return info;
        }
        catch (ResourceLocationException ex) {
            return null;
        }
    }
}

