/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;

public class ClocheRecipeBuilder
extends IEFinishedRecipe<ClocheRecipeBuilder> {
    private boolean hasRender = false;

    private ClocheRecipeBuilder() {
        super((IERecipeSerializer)ClocheRecipe.SERIALIZER.get());
        this.setMultipleResults(4);
    }

    public static ClocheRecipeBuilder builder(Item result) {
        return (ClocheRecipeBuilder)new ClocheRecipeBuilder().addResult((IItemProvider)result);
    }

    public static ClocheRecipeBuilder builder(ItemStack result) {
        return (ClocheRecipeBuilder)new ClocheRecipeBuilder().addResult(result);
    }

    public static ClocheRecipeBuilder builder(ITag<Item> result, int count) {
        return (ClocheRecipeBuilder)new ClocheRecipeBuilder().addResult(new IngredientWithSize(result, count));
    }

    public ClocheRecipeBuilder addSoil(IItemProvider itemProvider) {
        return (ClocheRecipeBuilder)this.addItem("soil", new ItemStack(itemProvider));
    }

    public ClocheRecipeBuilder addSoil(ItemStack itemStack) {
        return (ClocheRecipeBuilder)this.addItem("soil", itemStack);
    }

    public ClocheRecipeBuilder addSoil(ITag<Item> tag) {
        return this.addSoil(Ingredient.func_199805_a(tag));
    }

    public ClocheRecipeBuilder addSoil(Ingredient ingredient) {
        return (ClocheRecipeBuilder)this.addWriter(jsonObject -> jsonObject.add("soil", ingredient.func_200304_c()));
    }

    public ClocheRecipeBuilder setRender(ClocheRenderFunction.ClocheRenderReference renderReference) {
        Preconditions.checkArgument((!this.hasRender ? 1 : 0) != 0, (Object)"This recipe already has a render set.");
        this.hasRender = true;
        return (ClocheRecipeBuilder)this.addWriter(jsonObject -> jsonObject.add("render", (JsonElement)renderReference.serialize()));
    }

    @Override
    protected boolean isComplete() {
        return super.isComplete() && this.hasRender;
    }
}

